/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterators;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class MediaTypeSet
extends AbstractSet<MediaType> {
    private static final String Q = "q";
    private static final MediaType[] EMPTY_MEDIA_TYPES = new MediaType[0];
    private final MediaType[] mediaTypes;
    private static final int ST_SKIP_LEADING_WHITESPACES = 0;
    private static final int ST_READ_QDTEXT = 1;
    private static final int ST_READ_QUOTED_STRING = 2;
    private static final int ST_READ_QUOTED_STRING_ESCAPED = 3;

    public MediaTypeSet(MediaType ... mediaTypes) {
        this(ImmutableList.copyOf(Objects.requireNonNull(mediaTypes, "mediaTypes")));
    }

    public MediaTypeSet(Iterable<MediaType> mediaTypes) {
        LinkedHashSet<MediaType> mediaTypesCopy = new LinkedHashSet<MediaType>();
        for (MediaType mediaType : Objects.requireNonNull(mediaTypes, "mediaTypes")) {
            Objects.requireNonNull(mediaType, "mediaTypes contains null.");
            Preconditions.checkArgument(!mediaType.hasWildcard(), "mediaTypes contains a wildcard media type: %s", (Object)mediaType);
            List<String> otherQValues = mediaType.parameters().get(Q);
            Preconditions.checkArgument(otherQValues == null || otherQValues.isEmpty(), "mediaTypes contains a media type with a q-value parameter: %s", (Object)mediaType);
            mediaTypesCopy.add(mediaType);
        }
        this.mediaTypes = mediaTypesCopy.toArray(EMPTY_MEDIA_TYPES);
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof MediaType)) {
            return false;
        }
        for (MediaType e : this.mediaTypes) {
            if (!e.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<MediaType> iterator() {
        return Iterators.forArray(this.mediaTypes);
    }

    @Override
    public int size() {
        return this.mediaTypes.length;
    }

    public Optional<MediaType> matchHeaders(Iterable<? extends CharSequence> acceptHeaders) {
        Objects.requireNonNull(acceptHeaders, "acceptHeaders");
        ArrayList<MediaType> ranges = new ArrayList<MediaType>(4);
        for (CharSequence charSequence : acceptHeaders) {
            MediaTypeSet.addRanges(ranges, charSequence);
        }
        return this.match(ranges);
    }

    public Optional<MediaType> matchHeaders(CharSequence ... acceptHeaders) {
        Objects.requireNonNull(acceptHeaders, "acceptHeaders");
        ArrayList<MediaType> ranges = new ArrayList<MediaType>(4);
        for (CharSequence acceptHeader : acceptHeaders) {
            MediaTypeSet.addRanges(ranges, acceptHeader);
        }
        return this.match(ranges);
    }

    public Optional<MediaType> match(MediaType ... ranges) {
        return this.match(Arrays.asList(Objects.requireNonNull(ranges, "ranges")));
    }

    public Optional<MediaType> match(Iterable<MediaType> ranges) {
        Objects.requireNonNull(ranges, "ranges");
        MediaType match = null;
        float matchQ = Float.NEGATIVE_INFINITY;
        int matchNumWildcards = Integer.MAX_VALUE;
        int matchNumParams = Integer.MIN_VALUE;
        for (MediaType range : ranges) {
            Objects.requireNonNull(range, "ranges contains null.");
            for (MediaType candidate : this.mediaTypes) {
                int numParams;
                if (!candidate.belongsTo(range)) continue;
                float qValue = range.qualityFactor(Float.NEGATIVE_INFINITY);
                int numWildcards = range.numWildcards();
                if (qValue < 0.0f) {
                    qValue = 1.0f;
                    numParams = range.parameters().size();
                } else {
                    numParams = range.parameters().size() - 1;
                }
                boolean isBetter = qValue > matchQ ? true : (Math.copySign(qValue - matchQ, 1.0f) <= 1.0E-4f ? (matchNumWildcards > numWildcards ? true : (matchNumWildcards == numWildcards ? numParams > matchNumParams : false)) : false);
                if (!isBetter) continue;
                match = candidate;
                matchQ = qValue;
                matchNumWildcards = numWildcards;
                matchNumParams = numParams;
            }
        }
        return Optional.ofNullable(match);
    }

    static void addRanges(List<MediaType> ranges, CharSequence header) {
        int length = header.length();
        int state = 0;
        int firstCharIdx = 0;
        int lastCharIdx = -1;
        block14: for (int i = 0; i < length; ++i) {
            char ch = header.charAt(i);
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(ch)) continue block14;
                    state = 1;
                    firstCharIdx = i;
                    lastCharIdx = -1;
                }
                case 1: {
                    if (Character.isWhitespace(ch)) continue block14;
                    switch (ch) {
                        case '\"': {
                            state = 2;
                            continue block14;
                        }
                        case ',': {
                            MediaTypeSet.addRange(ranges, header, firstCharIdx, lastCharIdx);
                            state = 0;
                            continue block14;
                        }
                    }
                    lastCharIdx = i;
                    continue block14;
                }
                case 2: {
                    switch (ch) {
                        case '\\': {
                            state = 3;
                            break;
                        }
                        case '\"': {
                            state = 1;
                            lastCharIdx = i;
                        }
                    }
                    continue block14;
                }
                case 3: {
                    state = 2;
                }
            }
        }
        if (state == 1) {
            MediaTypeSet.addRange(ranges, header, firstCharIdx, lastCharIdx);
        }
    }

    private static void addRange(List<MediaType> ranges, CharSequence header, int firstCharIdx, int lastCharIdx) {
        if (lastCharIdx >= 0) {
            try {
                ranges.add(MediaType.parse(header.subSequence(firstCharIdx, lastCharIdx + 1).toString()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

