/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.AbstractRequestContext;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.DefaultAttributeMap;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSession;

public abstract class NonWrappingRequestContext
extends AbstractRequestContext {
    private final MeterRegistry meterRegistry;
    private final DefaultAttributeMap attrs = new DefaultAttributeMap();
    private final SessionProtocol sessionProtocol;
    private final HttpMethod method;
    private final String path;
    @Nullable
    private String decodedPath;
    @Nullable
    private final String query;
    private final Request request;
    @Nullable
    private List<Consumer<? super RequestContext>> onEnterCallbacks;
    @Nullable
    private List<Consumer<? super RequestContext>> onExitCallbacks;
    @Nullable
    private List<BiConsumer<? super RequestContext, ? super RequestContext>> onChildCallbacks;

    protected NonWrappingRequestContext(MeterRegistry meterRegistry, SessionProtocol sessionProtocol, HttpMethod method, String path, @Nullable String query, Request request) {
        this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
        this.sessionProtocol = Objects.requireNonNull(sessionProtocol, "sessionProtocol");
        this.method = Objects.requireNonNull(method, "method");
        this.path = Objects.requireNonNull(path, "path");
        this.query = query;
        this.request = Objects.requireNonNull(request, "request");
    }

    @Override
    public final SessionProtocol sessionProtocol() {
        return this.sessionProtocol;
    }

    @Nullable
    protected abstract Channel channel();

    @Override
    @Nullable
    public <A extends SocketAddress> A remoteAddress() {
        Channel ch = this.channel();
        return (A)(ch != null ? ch.remoteAddress() : null);
    }

    @Override
    @Nullable
    public <A extends SocketAddress> A localAddress() {
        Channel ch = this.channel();
        return (A)(ch != null ? ch.localAddress() : null);
    }

    @Override
    @Nullable
    public SSLSession sslSession() {
        Channel ch = this.channel();
        if (ch == null) {
            return null;
        }
        SslHandler sslHandler = (SslHandler)ch.pipeline().get(SslHandler.class);
        return sslHandler != null ? sslHandler.engine().getSession() : null;
    }

    @Override
    public final HttpMethod method() {
        return this.method;
    }

    @Override
    public final String path() {
        return this.path;
    }

    @Override
    public final String decodedPath() {
        String decodedPath = this.decodedPath;
        if (decodedPath != null) {
            return decodedPath;
        }
        this.decodedPath = ArmeriaHttpUtil.decodePath(this.path);
        return this.decodedPath;
    }

    @Override
    public final String query() {
        return this.query;
    }

    @Override
    public final <T extends Request> T request() {
        return (T)this.request;
    }

    @Override
    public final MeterRegistry meterRegistry() {
        return this.meterRegistry;
    }

    public <T> Attribute<T> attr(AttributeKey<T> key) {
        return this.attrs.attr(key);
    }

    public <T> boolean hasAttr(AttributeKey<T> key) {
        return this.attrs.hasAttr(key);
    }

    @Override
    public Iterator<Attribute<?>> attrs() {
        return this.attrs.attrs();
    }

    @Override
    public final void onEnter(Consumer<? super RequestContext> callback) {
        Objects.requireNonNull(callback, "callback");
        if (this.onEnterCallbacks == null) {
            this.onEnterCallbacks = new ArrayList<Consumer<? super RequestContext>>(4);
        }
        this.onEnterCallbacks.add(callback);
    }

    @Override
    public final void onExit(Consumer<? super RequestContext> callback) {
        Objects.requireNonNull(callback, "callback");
        if (this.onExitCallbacks == null) {
            this.onExitCallbacks = new ArrayList<Consumer<? super RequestContext>>(4);
        }
        this.onExitCallbacks.add(callback);
    }

    @Override
    public final void onChild(BiConsumer<? super RequestContext, ? super RequestContext> callback) {
        Objects.requireNonNull(callback, "callback");
        if (this.onChildCallbacks == null) {
            this.onChildCallbacks = new ArrayList<BiConsumer<? super RequestContext, ? super RequestContext>>(4);
        }
        this.onChildCallbacks.add(callback);
    }

    @Override
    public void invokeOnEnterCallbacks() {
        this.invokeCallbacks(this.onEnterCallbacks);
    }

    @Override
    public void invokeOnExitCallbacks() {
        this.invokeCallbacks(this.onExitCallbacks);
    }

    private void invokeCallbacks(@Nullable List<Consumer<? super RequestContext>> callbacks) {
        if (callbacks == null) {
            return;
        }
        for (Consumer<? super RequestContext> callback : callbacks) {
            callback.accept(this);
        }
    }

    @Override
    public void invokeOnChildCallbacks(RequestContext newCtx) {
        List<BiConsumer<? super RequestContext, ? super RequestContext>> callbacks = this.onChildCallbacks;
        if (callbacks == null) {
            return;
        }
        for (BiConsumer<? super RequestContext, ? super RequestContext> callback : callbacks) {
            callback.accept(this, newCtx);
        }
    }
}

