/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestContextAwareEventLoop;
import com.linecorp.armeria.common.RequestContextAwareExecutorService;
import com.linecorp.armeria.common.RequestContextThreadLocal;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.TimeoutException;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.SafeCloseable;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoop;
import io.netty.util.Attribute;
import io.netty.util.AttributeMap;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSession;
import org.slf4j.LoggerFactory;

public interface RequestContext
extends AttributeMap {
    public RequestContext newDerivedContext();

    public RequestContext newDerivedContext(Request var1);

    public static <T extends RequestContext> T current() {
        Object ctx = RequestContextThreadLocal.get();
        if (ctx == null) {
            throw new IllegalStateException(RequestContext.class.getSimpleName() + " unavailable");
        }
        return ctx;
    }

    @Nullable
    public static <T> T mapCurrent(Function<? super RequestContext, T> mapper, @Nullable Supplier<T> defaultValueSupplier) {
        Object ctx = RequestContextThreadLocal.get();
        if (ctx != null) {
            return mapper.apply((RequestContext)ctx);
        }
        if (defaultValueSupplier != null) {
            return defaultValueSupplier.get();
        }
        return null;
    }

    public SessionProtocol sessionProtocol();

    @Nullable
    public <A extends SocketAddress> A remoteAddress();

    @Nullable
    public <A extends SocketAddress> A localAddress();

    @Nullable
    public SSLSession sslSession();

    public HttpMethod method();

    public String path();

    public String decodedPath();

    @Nullable
    public String query();

    public <T extends Request> T request();

    public RequestLog log();

    public RequestLogBuilder logBuilder();

    public MeterRegistry meterRegistry();

    public Iterator<Attribute<?>> attrs();

    default public Executor executor() {
        return this.eventLoop();
    }

    public EventLoop eventLoop();

    default public ByteBufAllocator alloc() {
        throw new UnsupportedOperationException("No ByteBufAllocator available for this RequestContext.");
    }

    default public Executor contextAwareExecutor() {
        return this.contextAwareEventLoop();
    }

    default public EventLoop contextAwareEventLoop() {
        return new RequestContextAwareEventLoop(this, this.eventLoop());
    }

    @Deprecated
    public static SafeCloseable push(RequestContext ctx) {
        return ctx.push(true);
    }

    @Deprecated
    public static SafeCloseable push(RequestContext ctx, boolean runCallbacks) {
        return ctx.push(runCallbacks);
    }

    default public SafeCloseable push() {
        return this.push(true);
    }

    default public SafeCloseable push(boolean runCallbacks) {
        Object oldCtx = RequestContextThreadLocal.getAndSet(this);
        if (oldCtx == this) {
            return () -> {};
        }
        if (runCallbacks) {
            if (oldCtx != null) {
                oldCtx.invokeOnChildCallbacks(this);
                this.invokeOnEnterCallbacks();
                return () -> {
                    this.invokeOnExitCallbacks();
                    RequestContextThreadLocal.set(oldCtx);
                };
            }
            this.invokeOnEnterCallbacks();
            return () -> {
                this.invokeOnExitCallbacks();
                RequestContextThreadLocal.remove();
            };
        }
        if (oldCtx != null) {
            return () -> RequestContextThreadLocal.set(oldCtx);
        }
        return RequestContextThreadLocal::remove;
    }

    default public SafeCloseable pushIfAbsent() {
        Object currentRequestContext = RequestContextThreadLocal.get();
        if (currentRequestContext != null && currentRequestContext != this) {
            throw new IllegalStateException("Trying to call object wrapped with context " + this + ", but context is currently set to " + currentRequestContext + ". This means the callback was called from unexpected thread or forgetting to close previous context.");
        }
        return this.push();
    }

    default public Executor makeContextAware(Executor executor) {
        return runnable -> executor.execute(this.makeContextAware(runnable));
    }

    default public ExecutorService makeContextAware(ExecutorService executor) {
        return new RequestContextAwareExecutorService(this, executor);
    }

    public <T> Callable<T> makeContextAware(Callable<T> var1);

    public Runnable makeContextAware(Runnable var1);

    public <T, R> Function<T, R> makeContextAware(Function<T, R> var1);

    public <T, U, V> BiFunction<T, U, V> makeContextAware(BiFunction<T, U, V> var1);

    public <T> Consumer<T> makeContextAware(Consumer<T> var1);

    public <T, U> BiConsumer<T, U> makeContextAware(BiConsumer<T, U> var1);

    @Deprecated
    public <T> FutureListener<T> makeContextAware(FutureListener<T> var1);

    @Deprecated
    public ChannelFutureListener makeContextAware(ChannelFutureListener var1);

    @Deprecated
    public <T extends Future<?>> GenericFutureListener<T> makeContextAware(GenericFutureListener<T> var1);

    public <T> CompletionStage<T> makeContextAware(CompletionStage<T> var1);

    default public <T> CompletableFuture<T> makeContextAware(CompletableFuture<T> future) {
        return this.makeContextAware((CompletionStage<T>)future).toCompletableFuture();
    }

    public boolean isTimedOut();

    public void onEnter(Consumer<? super RequestContext> var1);

    @Deprecated
    default public void onEnter(Runnable callback) {
        this.onEnter((? super RequestContext ctx) -> callback.run());
    }

    public void onExit(Consumer<? super RequestContext> var1);

    @Deprecated
    default public void onExit(Runnable callback) {
        this.onExit((? super RequestContext ctx) -> callback.run());
    }

    public void onChild(BiConsumer<? super RequestContext, ? super RequestContext> var1);

    public void invokeOnEnterCallbacks();

    public void invokeOnExitCallbacks();

    public void invokeOnChildCallbacks(RequestContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    default public void resolvePromise(Promise<?> promise, Object result) {
        Promise<?> castPromise = promise;
        if (castPromise.trySuccess(result)) {
            return;
        }
        try {
            if (!(promise.cause() instanceof TimeoutException)) {
                LoggerFactory.getLogger(RequestContext.class).warn("Failed to resolve a completed promise ({}) with {}", promise, result);
            }
        }
        finally {
            ReferenceCountUtil.safeRelease((Object)result);
        }
    }

    @Deprecated
    default public void rejectPromise(Promise<?> promise, Throwable cause) {
        if (promise.tryFailure(cause)) {
            return;
        }
        Throwable firstCause = promise.cause();
        if (firstCause instanceof TimeoutException) {
            return;
        }
        if (Exceptions.isExpected(cause)) {
            return;
        }
        LoggerFactory.getLogger(RequestContext.class).warn("Failed to reject a completed promise ({}) with {}", new Object[]{promise, cause, cause});
    }
}

