/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestContextAwareExecutorService;
import com.linecorp.armeria.common.RequestContextAwareFuture;
import com.linecorp.armeria.common.RequestContextAwareProgressivePromise;
import com.linecorp.armeria.common.RequestContextAwarePromise;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ProgressivePromise;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

final class RequestContextAwareEventLoop
extends RequestContextAwareExecutorService
implements EventLoop {
    RequestContextAwareEventLoop(RequestContext context, EventLoop delegate) {
        super(context, (ExecutorService)delegate);
    }

    protected EventLoop delegate() {
        return (EventLoop)super.delegate();
    }

    public EventLoop next() {
        return this;
    }

    public EventLoopGroup parent() {
        return this.delegate().parent();
    }

    public boolean inEventLoop() {
        return this.delegate().inEventLoop();
    }

    public boolean inEventLoop(Thread thread) {
        return this.delegate().inEventLoop(thread);
    }

    public <V> Promise<V> newPromise() {
        return new RequestContextAwarePromise(this.context(), this.delegate().newPromise());
    }

    public <V> ProgressivePromise<V> newProgressivePromise() {
        return new RequestContextAwareProgressivePromise(this.context(), this.delegate().newProgressivePromise());
    }

    public <V> Future<V> newSucceededFuture(V result) {
        return new RequestContextAwareFuture(this.context(), this.delegate().newSucceededFuture(result));
    }

    public <V> Future<V> newFailedFuture(Throwable cause) {
        return new RequestContextAwareFuture(this.context(), this.delegate().newFailedFuture(cause));
    }

    public boolean isShuttingDown() {
        return this.delegate().isShuttingDown();
    }

    public Future<?> shutdownGracefully() {
        return this.delegate().shutdownGracefully();
    }

    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        return this.delegate().shutdownGracefully(quietPeriod, timeout, unit);
    }

    public Future<?> terminationFuture() {
        return this.delegate().terminationFuture();
    }

    public Iterator<EventExecutor> iterator() {
        return this.delegate().iterator();
    }

    public Future<?> submit(Runnable task) {
        return (Future)super.submit(task);
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return (Future)super.submit(task, result);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return (Future)super.submit(task);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.delegate().schedule(this.context().makeContextAware(command), delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.delegate().schedule(this.context().makeContextAware(callable), delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.delegate().scheduleAtFixedRate(this.context().makeContextAware(command), initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.delegate().scheduleWithFixedDelay(this.context().makeContextAware(command), initialDelay, delay, unit);
    }

    public ChannelFuture register(Channel channel) {
        return this.delegate().register(channel);
    }

    public ChannelFuture register(ChannelPromise channelPromise) {
        return this.delegate().register(channelPromise);
    }

    public ChannelFuture register(Channel channel, ChannelPromise channelPromise) {
        return this.delegate().register(channel, channelPromise);
    }
}

