/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.DefaultRpcRequest;
import com.linecorp.armeria.common.Request;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public interface RpcRequest
extends Request {
    public static RpcRequest of(Class<?> serviceType, String method) {
        return new DefaultRpcRequest(serviceType, method, Collections.emptyList());
    }

    public static RpcRequest of(Class<?> serviceType, String method, @Nullable Object parameter) {
        return new DefaultRpcRequest(serviceType, method, (Iterable<?>)Collections.singletonList(parameter));
    }

    public static RpcRequest of(Class<?> serviceType, String method, Iterable<?> params) {
        Objects.requireNonNull(params, "params");
        if (!(params instanceof Collection)) {
            return new DefaultRpcRequest(serviceType, method, params);
        }
        Collection paramCollection = (Collection)params;
        switch (paramCollection.size()) {
            case 0: {
                return RpcRequest.of(serviceType, method);
            }
            case 1: {
                if (paramCollection instanceof List) {
                    return RpcRequest.of(serviceType, method, ((List)paramCollection).get(0));
                }
                return RpcRequest.of(serviceType, method, paramCollection.iterator().next());
            }
        }
        return new DefaultRpcRequest(serviceType, method, paramCollection.toArray());
    }

    public static RpcRequest of(Class<?> serviceType, String method, Object ... params) {
        Objects.requireNonNull(params, "params");
        switch (params.length) {
            case 0: {
                return RpcRequest.of(serviceType, method);
            }
            case 1: {
                return RpcRequest.of(serviceType, method, params[0]);
            }
        }
        return new DefaultRpcRequest(serviceType, method, params);
    }

    public Class<?> serviceType();

    public String method();

    public List<Object> params();
}

