/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.DefaultRpcResponse;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.util.Exceptions;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import javax.annotation.Nullable;

public interface RpcResponse
extends Response,
CompletionStage<Object>,
Future<Object> {
    public static RpcResponse of(@Nullable Object value) {
        return new DefaultRpcResponse(value);
    }

    public static RpcResponse ofFailure(Throwable cause) {
        return new DefaultRpcResponse(cause);
    }

    public static RpcResponse from(CompletionStage<?> stage) {
        Objects.requireNonNull(stage, "stage");
        DefaultRpcResponse res = new DefaultRpcResponse();
        stage.whenComplete((value, cause) -> {
            if (cause != null) {
                res.completeExceptionally((Throwable)cause);
                return;
            }
            if (value instanceof RpcResponse) {
                ((RpcResponse)value).whenComplete((rpcResponseResult, rpcResponseCause) -> {
                    if (rpcResponseCause != null) {
                        res.completeExceptionally(Exceptions.peel(rpcResponseCause));
                        return;
                    }
                    res.complete(rpcResponseResult);
                });
            } else {
                res.complete(value);
            }
        });
        return res;
    }

    public Object join();

    public Object getNow(Object var1);

    @Nullable
    public Throwable cause();

    public boolean isCompletedExceptionally();

    @Override
    default public CompletableFuture<?> completionFuture() {
        return this.toCompletableFuture();
    }
}

