/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class Scheme
implements Comparable<Scheme> {
    private static final Map<String, Scheme> SCHEMES;
    private final SerializationFormat serializationFormat;
    private final SessionProtocol sessionProtocol;
    private final String uriText;

    public static Optional<Scheme> tryParse(@Nullable String scheme) {
        if (scheme == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(SCHEMES.get(Ascii.toLowerCase(scheme)));
    }

    public static Scheme parse(String scheme) {
        Scheme res = SCHEMES.get(Ascii.toLowerCase(Objects.requireNonNull(scheme, "scheme")));
        if (res == null) {
            throw new IllegalArgumentException("scheme: " + scheme);
        }
        return res;
    }

    public static Scheme of(SerializationFormat serializationFormat, SessionProtocol sessionProtocol) {
        return SCHEMES.get(Objects.requireNonNull(serializationFormat, "serializationFormat").uriText() + '+' + Objects.requireNonNull(sessionProtocol, "sessionProtocol").uriText());
    }

    private Scheme(SerializationFormat serializationFormat, SessionProtocol sessionProtocol) {
        this.serializationFormat = Objects.requireNonNull(serializationFormat, "serializationFormat");
        this.sessionProtocol = Objects.requireNonNull(sessionProtocol, "sessionProtocol");
        this.uriText = this.serializationFormat().uriText() + '+' + this.sessionProtocol().uriText();
    }

    public SerializationFormat serializationFormat() {
        return this.serializationFormat;
    }

    public SessionProtocol sessionProtocol() {
        return this.sessionProtocol;
    }

    public String uriText() {
        return this.uriText;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int compareTo(Scheme o) {
        return this.uriText().compareTo(o.uriText());
    }

    public String toString() {
        return this.uriText();
    }

    static {
        ImmutableMap.Builder<String, Scheme> schemes = ImmutableMap.builder();
        for (SerializationFormat f : SerializationFormat.values()) {
            for (SessionProtocol p : SessionProtocol.values()) {
                String ftxt = f.uriText();
                String ptxt = p.uriText();
                assert (ftxt.equals(Ascii.toLowerCase(ftxt)));
                assert (ptxt.equals(Ascii.toLowerCase(ptxt)));
                Scheme scheme = new Scheme(f, p);
                schemes.put(ftxt + '+' + ptxt, scheme);
                schemes.put(ptxt + '+' + ftxt, scheme);
            }
        }
        SCHEMES = schemes.build();
    }
}

