/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.MediaTypeSet;
import com.linecorp.armeria.common.SerializationFormatProvider;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.BiMap;
import com.linecorp.armeria.internal.shaded.guava.collect.HashBiMap;
import com.linecorp.armeria.internal.shaded.guava.collect.HashMultimap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableBiMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Multimap;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.Nullable;

public final class SerializationFormat
implements Comparable<SerializationFormat> {
    private static final BiMap<String, SerializationFormat> uriTextToFormats;
    private static final Set<SerializationFormat> values;
    public static final SerializationFormat NONE;
    public static final SerializationFormat UNKNOWN;
    @Nullable
    @Deprecated
    public static final SerializationFormat THRIFT_BINARY;
    @Nullable
    @Deprecated
    public static final SerializationFormat THRIFT_COMPACT;
    @Nullable
    @Deprecated
    public static final SerializationFormat THRIFT_JSON;
    @Nullable
    @Deprecated
    public static final SerializationFormat THRIFT_TEXT;
    @Nullable
    private static final Set<SerializationFormat> THRIFT_FORMATS;
    private final String uriText;
    private final MediaType primaryMediaType;
    private final MediaTypeSet mediaTypes;

    private static SerializationFormat register(BiMap<String, SerializationFormat> uriTextToFormats, Multimap<MediaType, SerializationFormat> simplifiedMediaTypeToFormats, SerializationFormatProvider.Entry entry) {
        Preconditions.checkState(!uriTextToFormats.containsKey(entry.uriText), "serialization format registered already: ", entry.uriText);
        SerializationFormat value = new SerializationFormat(entry.uriText, entry.primaryMediaType, entry.mediaTypes);
        for (MediaType type : entry.mediaTypes) {
            SerializationFormat.checkMediaType(simplifiedMediaTypeToFormats, type);
        }
        uriTextToFormats.put(entry.uriText, value);
        for (MediaType type : entry.mediaTypes) {
            simplifiedMediaTypeToFormats.put(type.withoutParameters(), value);
        }
        return value;
    }

    @Deprecated
    public static Set<SerializationFormat> ofThrift() {
        if (THRIFT_FORMATS == null) {
            throw new IllegalStateException("Thrift support not available");
        }
        return THRIFT_FORMATS;
    }

    private static void checkMediaType(Multimap<MediaType, SerializationFormat> simplifiedMediaTypeToFormats, MediaType mediaType) {
        MediaType simplifiedMediaType = mediaType.withoutParameters();
        for (SerializationFormat format : simplifiedMediaTypeToFormats.get(simplifiedMediaType)) {
            for (MediaType registeredMediaType : format.mediaTypes()) {
                Preconditions.checkState(!registeredMediaType.is(mediaType) && !mediaType.is(registeredMediaType), "media type registered already: ", mediaType);
            }
        }
    }

    public static Set<SerializationFormat> values() {
        return values;
    }

    public static SerializationFormat of(String uriText) {
        SerializationFormat value = (SerializationFormat)uriTextToFormats.get(uriText = Ascii.toLowerCase(Objects.requireNonNull(uriText, "uriText")));
        Preconditions.checkArgument(value != null, "unknown serialization format: ", (Object)uriText);
        return value;
    }

    public static Optional<SerializationFormat> find(String uriText) {
        uriText = Ascii.toLowerCase(Objects.requireNonNull(uriText, "uriText"));
        return Optional.ofNullable((SerializationFormat)uriTextToFormats.get(uriText));
    }

    public static Optional<SerializationFormat> find(MediaType ... ranges) {
        Objects.requireNonNull(ranges, "ranges");
        if (ranges.length == 0) {
            return Optional.empty();
        }
        for (SerializationFormat f : SerializationFormat.values()) {
            if (!f.isAccepted(ranges)) continue;
            return Optional.of(f);
        }
        return Optional.empty();
    }

    @Deprecated
    public static Optional<SerializationFormat> fromMediaType(@Nullable String mediaType) {
        if (mediaType == null) {
            return Optional.empty();
        }
        try {
            return SerializationFormat.find(MediaType.parse(mediaType));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private SerializationFormat(String uriText, MediaType primaryMediaType, MediaTypeSet mediaTypes) {
        this.uriText = uriText;
        this.primaryMediaType = primaryMediaType;
        this.mediaTypes = mediaTypes;
    }

    public String uriText() {
        return this.uriText;
    }

    public MediaType mediaType() {
        return this.primaryMediaType;
    }

    public MediaTypeSet mediaTypes() {
        return this.mediaTypes;
    }

    public boolean isAccepted(MediaType ... ranges) {
        Objects.requireNonNull(ranges, "ranges");
        return this.mediaTypes.match(ranges).isPresent();
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int compareTo(SerializationFormat o) {
        return this.uriText.compareTo(o.uriText);
    }

    public String toString() {
        return this.uriText;
    }

    static {
        HashBiMap<String, SerializationFormat> mutableUriTextToFormats = HashBiMap.create();
        HashMultimap<MediaType, SerializationFormat> mutableSimplifiedMediaTypeToFormats = HashMultimap.create();
        NONE = SerializationFormat.register(mutableUriTextToFormats, mutableSimplifiedMediaTypeToFormats, new SerializationFormatProvider.Entry("none", MediaType.create("application", "x-none"), new MediaType[0]));
        UNKNOWN = SerializationFormat.register(mutableUriTextToFormats, mutableSimplifiedMediaTypeToFormats, new SerializationFormatProvider.Entry("unknown", MediaType.create("application", "x-unknown"), new MediaType[0]));
        ServiceLoader.load(SerializationFormatProvider.class, SerializationFormatProvider.class.getClassLoader()).forEach(p -> p.entries().forEach(e -> SerializationFormat.register(mutableUriTextToFormats, mutableSimplifiedMediaTypeToFormats, e)));
        uriTextToFormats = ImmutableBiMap.copyOf(mutableUriTextToFormats);
        values = uriTextToFormats.values();
        SerializationFormat tbinary = null;
        SerializationFormat tcompact = null;
        SerializationFormat tjson = null;
        SerializationFormat ttext = null;
        ImmutableSet<SerializationFormat> thriftFormats = null;
        try {
            tbinary = SerializationFormat.of("tbinary");
            tcompact = SerializationFormat.of("tcompact");
            tjson = SerializationFormat.of("tjson");
            ttext = SerializationFormat.of("ttext");
            thriftFormats = ImmutableSet.of(tbinary, tcompact, tjson, ttext);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        THRIFT_BINARY = tbinary;
        THRIFT_COMPACT = tcompact;
        THRIFT_JSON = tjson;
        THRIFT_TEXT = ttext;
        THRIFT_FORMATS = thriftFormats;
    }
}

