/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import io.netty.handler.codec.DateFormatter;
import io.netty.handler.codec.ValueConverter;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.Nullable;

final class StringValueConverter
implements ValueConverter<String> {
    static final StringValueConverter INSTANCE = new StringValueConverter();

    private StringValueConverter() {
    }

    @Nullable
    public String convertObject(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return DateFormatter.format((Date)((Date)value));
        }
        if (value instanceof Calendar) {
            return DateFormatter.format((Date)((Calendar)value).getTime());
        }
        if (value instanceof Instant) {
            return DateFormatter.format((Date)new Date(((Instant)value).toEpochMilli()));
        }
        return value.toString();
    }

    public String convertInt(int value) {
        return String.valueOf(value);
    }

    public String convertLong(long value) {
        return String.valueOf(value);
    }

    public String convertDouble(double value) {
        return String.valueOf(value);
    }

    public String convertChar(char value) {
        return String.valueOf(value);
    }

    public String convertBoolean(boolean value) {
        return String.valueOf(value);
    }

    public String convertFloat(float value) {
        return String.valueOf(value);
    }

    public boolean convertToBoolean(String value) {
        return Boolean.parseBoolean(value);
    }

    public String convertByte(byte value) {
        return String.valueOf(value & 0xFF);
    }

    public byte convertToByte(String value) {
        return (byte)value.charAt(0);
    }

    public char convertToChar(String value) {
        return value.charAt(0);
    }

    public String convertShort(short value) {
        return String.valueOf(value);
    }

    public short convertToShort(String value) {
        return Short.valueOf(value);
    }

    public int convertToInt(String value) {
        return Integer.parseInt(value);
    }

    public long convertToLong(String value) {
        return Long.parseLong(value);
    }

    public String convertTimeMillis(long value) {
        return DateFormatter.format((Date)new Date(value));
    }

    public long convertToTimeMillis(String value) {
        Date date = DateFormatter.parseHttpDate((CharSequence)value);
        if (date == null) {
            throw new IllegalArgumentException("not a date: " + value);
        }
        return date.getTime();
    }

    public float convertToFloat(String value) {
        return Float.valueOf(value).floatValue();
    }

    public double convertToDouble(String value) {
        return Double.valueOf(value);
    }
}

