/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RpcResponse;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.common.logging.RequestLogAvailabilitySet;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.logging.RequestLogListener;
import com.linecorp.armeria.common.logging.RequestLogListenerInvoker;
import com.linecorp.armeria.common.util.TextFormatter;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.channel.Channel;
import io.netty.util.internal.PlatformDependent;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Function;
import javax.annotation.Nullable;

public class DefaultRequestLog
implements RequestLog,
RequestLogBuilder {
    private static final AtomicIntegerFieldUpdater<DefaultRequestLog> flagsUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultRequestLog.class, "flags");
    private static final int FLAGS_REQUEST_END_WITHOUT_CONTENT = RequestLogAvailability.REQUEST_END.setterFlags() & ~RequestLogAvailability.REQUEST_CONTENT.setterFlags();
    private static final int FLAGS_RESPONSE_END_WITHOUT_CONTENT = RequestLogAvailability.RESPONSE_END.setterFlags() & ~RequestLogAvailability.RESPONSE_CONTENT.setterFlags();
    private static final int STRING_BUILDER_CAPACITY = 512;
    private static final HttpHeaders DUMMY_REQUEST_HEADERS_HTTP = HttpHeaders.of().scheme("http").authority("?").method(HttpMethod.UNKNOWN).path("?").asImmutable();
    private static final HttpHeaders DUMMY_REQUEST_HEADERS_HTTPS = HttpHeaders.of().scheme("https").authority("?").method(HttpMethod.UNKNOWN).path("?").asImmutable();
    private static final HttpHeaders DUMMY_RESPONSE_HEADERS = HttpHeaders.of(HttpStatus.UNKNOWN).asImmutable();
    private final RequestContext ctx;
    @Nullable
    private List<RequestLog> children;
    private boolean hasLastChild;
    private volatile int flags;
    private final List<ListenerEntry> listeners = new ArrayList<ListenerEntry>(4);
    private volatile boolean requestContentDeferred;
    private volatile boolean responseContentDeferred;
    private long requestStartTimeMicros;
    private long requestStartTimeNanos;
    private long requestEndTimeNanos;
    private long requestLength;
    @Nullable
    private Throwable requestCause;
    private long responseStartTimeMicros;
    private long responseStartTimeNanos;
    private long responseEndTimeNanos;
    private long responseLength;
    @Nullable
    private Throwable responseCause;
    @Nullable
    private Channel channel;
    @Nullable
    private SessionProtocol sessionProtocol;
    private SerializationFormat serializationFormat = SerializationFormat.NONE;
    @Nullable
    private String host;
    private HttpHeaders requestHeaders = DUMMY_REQUEST_HEADERS_HTTP;
    private HttpHeaders responseHeaders = DUMMY_RESPONSE_HEADERS;
    @Nullable
    private Object requestContent;
    @Nullable
    private Object rawRequestContent;
    @Nullable
    private Object responseContent;
    @Nullable
    private Object rawResponseContent;
    private volatile int requestStrFlags = -1;
    private volatile int responseStrFlags = -1;
    @Nullable
    private String requestStr;
    @Nullable
    private String responseStr;

    public DefaultRequestLog(RequestContext ctx) {
        this.ctx = Objects.requireNonNull(ctx, "ctx");
    }

    @Override
    public void addChild(RequestLog child) {
        Preconditions.checkState(!this.hasLastChild, "last child is already added");
        Objects.requireNonNull(child, "child");
        if (this.children == null) {
            this.children = new ArrayList<RequestLog>();
            this.propagateRequestSideLog(child);
        }
        this.children.add(child);
    }

    private void propagateRequestSideLog(RequestLog child) {
        child.addListener((RequestLog log) -> this.startRequest0(log.requestStartTimeNanos(), log.requestStartTimeMicros(), log.channel(), log.sessionProtocol(), true), RequestLogAvailability.REQUEST_START);
        child.addListener((RequestLog log) -> this.serializationFormat(log.serializationFormat()), RequestLogAvailability.SCHEME);
        child.addListener((RequestLog log) -> this.requestHeaders(log.requestHeaders()), RequestLogAvailability.REQUEST_HEADERS);
        child.addListener((RequestLog log) -> this.requestContent(log.requestContent(), log.rawRequestContent()), RequestLogAvailability.REQUEST_CONTENT);
        child.addListener((RequestLog log) -> {
            if (log.requestCause() != null) {
                this.endRequest0(log.requestEndTimeNanos(), log.requestCause());
            } else {
                this.endRequest0(log.requestEndTimeNanos(), null);
            }
        }, RequestLogAvailability.REQUEST_END);
    }

    @Override
    public void endResponseWithLastChild() {
        Preconditions.checkState(!this.hasLastChild, "last child is already added");
        Preconditions.checkState(this.children != null && !this.children.isEmpty(), "at least one child should be already added");
        this.hasLastChild = true;
        RequestLog lastChild = this.children.get(this.children.size() - 1);
        this.propagateResponseSideLog(lastChild);
    }

    private void propagateResponseSideLog(RequestLog lastChild) {
        if (lastChild.isAvailable(RequestLogAvailability.RESPONSE_START)) {
            this.startResponse0(lastChild.responseStartTimeNanos(), lastChild.responseStartTimeMicros(), true);
        }
        if (lastChild.isAvailable(RequestLogAvailability.RESPONSE_HEADERS)) {
            this.responseHeaders(lastChild.responseHeaders());
        }
        if (lastChild.isAvailable(RequestLogAvailability.RESPONSE_CONTENT)) {
            this.responseContent(lastChild.responseContent(), lastChild.rawResponseContent());
        }
        if (lastChild.isAvailable(RequestLogAvailability.RESPONSE_END)) {
            this.endResponseFrom(lastChild);
        }
        lastChild.addListener((RequestLog log) -> this.startResponse0(log.responseStartTimeNanos(), log.responseStartTimeMicros(), true), RequestLogAvailability.RESPONSE_START);
        lastChild.addListener((RequestLog log) -> this.responseHeaders(log.responseHeaders()), RequestLogAvailability.RESPONSE_HEADERS);
        lastChild.addListener((RequestLog log) -> this.responseContent(log.responseContent(), log.rawResponseContent()), RequestLogAvailability.RESPONSE_CONTENT);
        lastChild.addListener(this::endResponseFrom, RequestLogAvailability.RESPONSE_END);
    }

    private void endResponseFrom(RequestLog log) {
        if (log.responseCause() != null) {
            this.endResponse0(log.responseEndTimeNanos(), log.responseCause());
        } else {
            this.endResponse0(log.responseEndTimeNanos(), null);
        }
    }

    @Override
    public List<RequestLog> children() {
        return this.children != null ? ImmutableList.copyOf(this.children) : ImmutableList.of();
    }

    @Override
    public Set<RequestLogAvailability> availabilities() {
        return RequestLogAvailabilitySet.of(this.flags);
    }

    @Override
    public boolean isAvailable(RequestLogAvailability availability) {
        return this.isAvailable(availability.getterFlags());
    }

    @Override
    public boolean isAvailable(RequestLogAvailability ... availabilities) {
        return this.isAvailable(DefaultRequestLog.getterFlags(availabilities));
    }

    @Override
    public boolean isAvailable(Iterable<RequestLogAvailability> availabilities) {
        return this.isAvailable(DefaultRequestLog.getterFlags(availabilities));
    }

    private boolean isAvailable(int interestedFlags) {
        return (this.flags & interestedFlags) == interestedFlags;
    }

    private static boolean isAvailable(int flags, RequestLogAvailability availability) {
        int interestedFlags = availability.getterFlags();
        return (flags & interestedFlags) == interestedFlags;
    }

    private boolean isAvailabilityAlreadyUpdated(RequestLogAvailability availability) {
        return this.isAvailable(availability.setterFlags());
    }

    @Override
    public void addListener(RequestLogListener listener, RequestLogAvailability availability) {
        Objects.requireNonNull(listener, "listener");
        Objects.requireNonNull(availability, "availability");
        this.addListener(listener, availability.getterFlags());
    }

    @Override
    public void addListener(RequestLogListener listener, RequestLogAvailability ... availabilities) {
        Objects.requireNonNull(listener, "listener");
        Objects.requireNonNull(availabilities, "availabilities");
        this.addListener(listener, DefaultRequestLog.getterFlags(availabilities));
    }

    @Override
    public void addListener(RequestLogListener listener, Iterable<RequestLogAvailability> availabilities) {
        Objects.requireNonNull(listener, "listener");
        Objects.requireNonNull(availabilities, "availabilities");
        this.addListener(listener, DefaultRequestLog.getterFlags(availabilities));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(RequestLogListener listener, int interestedFlags) {
        RequestLogListener[] satisfiedListeners;
        if (interestedFlags == 0) {
            throw new IllegalArgumentException("no availability specified");
        }
        if (this.isAvailable(interestedFlags)) {
            RequestLogListenerInvoker.invokeOnRequestLog(listener, this);
            return;
        }
        ListenerEntry e = new ListenerEntry(listener, interestedFlags);
        List<ListenerEntry> list = this.listeners;
        synchronized (list) {
            this.listeners.add(e);
            satisfiedListeners = this.removeSatisfiedListeners();
        }
        this.notifyListeners(satisfiedListeners);
    }

    private static int getterFlags(RequestLogAvailability[] availabilities) {
        int flags = 0;
        for (RequestLogAvailability a : availabilities) {
            flags |= a.getterFlags();
        }
        return flags;
    }

    private static int getterFlags(Iterable<RequestLogAvailability> availabilities) {
        int flags = 0;
        for (RequestLogAvailability a : availabilities) {
            flags |= a.getterFlags();
        }
        return flags;
    }

    @Override
    public RequestContext context() {
        return this.ctx;
    }

    @Override
    public void startRequest(Channel channel, SessionProtocol sessionProtocol) {
        Objects.requireNonNull(channel, "channel");
        Objects.requireNonNull(sessionProtocol, "sessionProtocol");
        this.startRequest0(channel, sessionProtocol, true);
    }

    private void startRequest0(Channel channel, SessionProtocol sessionProtocol, boolean updateAvailability) {
        this.startRequest0(System.nanoTime(), DefaultRequestLog.currentTimeMicros(), channel, sessionProtocol, updateAvailability);
    }

    private void startRequest0(long requestStartTimeNanos, long requestStartTimeMicros, @Nullable Channel channel, SessionProtocol sessionProtocol, boolean updateAvailability) {
        if (this.isAvailabilityAlreadyUpdated(RequestLogAvailability.REQUEST_START)) {
            return;
        }
        this.requestStartTimeNanos = requestStartTimeNanos;
        this.requestStartTimeMicros = requestStartTimeMicros;
        this.channel = channel;
        this.sessionProtocol = sessionProtocol;
        if (sessionProtocol.isTls() && this.requestHeaders == DUMMY_REQUEST_HEADERS_HTTP) {
            this.requestHeaders = DUMMY_REQUEST_HEADERS_HTTPS;
        }
        if (updateAvailability) {
            this.updateAvailability(RequestLogAvailability.REQUEST_START);
        }
    }

    @Override
    public long requestStartTimeMicros() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_START);
        return this.requestStartTimeMicros;
    }

    @Override
    public long requestStartTimeMillis() {
        return TimeUnit.MICROSECONDS.toMillis(this.requestStartTimeMicros());
    }

    @Override
    public long requestStartTimeNanos() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_START);
        return this.requestStartTimeNanos;
    }

    @Override
    public long requestEndTimeNanos() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_END);
        return this.requestEndTimeNanos;
    }

    @Override
    public long requestDurationNanos() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_END);
        return this.requestEndTimeNanos - this.requestStartTimeNanos;
    }

    @Override
    public Throwable requestCause() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_END);
        return this.requestCause;
    }

    @Override
    public Channel channel() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_START);
        return this.channel;
    }

    @Override
    public SessionProtocol sessionProtocol() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_START);
        return this.sessionProtocol;
    }

    @Override
    public SerializationFormat serializationFormat() {
        this.ensureAvailability(RequestLogAvailability.SCHEME);
        return this.serializationFormat;
    }

    @Override
    public void serializationFormat(SerializationFormat serializationFormat) {
        if (this.isAvailabilityAlreadyUpdated(RequestLogAvailability.SCHEME)) {
            return;
        }
        this.serializationFormat = Objects.requireNonNull(serializationFormat, "serializationFormat");
        this.updateAvailability(RequestLogAvailability.SCHEME);
    }

    @Override
    public Scheme scheme() {
        this.ensureAvailability(RequestLogAvailability.SCHEME);
        return Scheme.of(this.serializationFormat, this.sessionProtocol);
    }

    @Override
    public long requestLength() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_END);
        return this.requestLength;
    }

    @Override
    public void requestLength(long requestLength) {
        if (requestLength < 0L) {
            throw new IllegalArgumentException("requestLength: " + requestLength + " (expected: >= 0)");
        }
        if (this.isAvailable(RequestLogAvailability.REQUEST_END)) {
            return;
        }
        this.requestLength = requestLength;
    }

    @Override
    public void increaseRequestLength(long deltaBytes) {
        if (deltaBytes < 0L) {
            throw new IllegalArgumentException("deltaBytes: " + deltaBytes + " (expected: >= 0)");
        }
        if (this.isAvailable(RequestLogAvailability.REQUEST_END)) {
            return;
        }
        this.requestLength += deltaBytes;
    }

    @Override
    public HttpHeaders requestHeaders() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_HEADERS);
        return this.requestHeaders;
    }

    @Override
    public void requestHeaders(HttpHeaders requestHeaders) {
        if (this.isAvailabilityAlreadyUpdated(RequestLogAvailability.REQUEST_HEADERS)) {
            return;
        }
        this.requestHeaders = Objects.requireNonNull(requestHeaders, "requestHeaders");
        this.updateAvailability(RequestLogAvailability.REQUEST_HEADERS);
    }

    @Override
    public Object requestContent() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_CONTENT);
        return this.requestContent;
    }

    @Override
    public void requestContent(@Nullable Object requestContent, @Nullable Object rawRequestContent) {
        if (this.isAvailabilityAlreadyUpdated(RequestLogAvailability.REQUEST_CONTENT)) {
            return;
        }
        this.requestContent = requestContent;
        this.rawRequestContent = rawRequestContent;
        this.updateAvailability(RequestLogAvailability.REQUEST_CONTENT);
    }

    @Override
    public Object rawRequestContent() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_CONTENT);
        return this.rawRequestContent;
    }

    @Override
    public void deferRequestContent() {
        if (this.isAvailabilityAlreadyUpdated(RequestLogAvailability.REQUEST_CONTENT)) {
            return;
        }
        this.requestContentDeferred = true;
    }

    @Override
    public boolean isRequestContentDeferred() {
        return this.requestContentDeferred;
    }

    @Override
    public void endRequest() {
        this.endRequest0(null);
    }

    @Override
    public void endRequest(Throwable requestCause) {
        this.endRequest0(Objects.requireNonNull(requestCause, "requestCause"));
    }

    private void endRequest0(@Nullable Throwable requestCause) {
        this.endRequest0(System.nanoTime(), requestCause);
    }

    private void endRequest0(long requestEndTimeNanos, @Nullable Throwable requestCause) {
        int flags;
        int n = flags = requestCause == null && this.requestContentDeferred ? FLAGS_REQUEST_END_WITHOUT_CONTENT : RequestLogAvailability.REQUEST_END.setterFlags();
        if (this.isAvailable(flags)) {
            return;
        }
        this.startRequest0(requestEndTimeNanos, DefaultRequestLog.currentTimeMicros(), null, this.context().sessionProtocol(), false);
        this.requestEndTimeNanos = requestEndTimeNanos;
        this.requestCause = requestCause;
        this.updateAvailability(flags);
    }

    @Override
    public void startResponse() {
        this.startResponse0(true);
    }

    private void startResponse0(boolean updateAvailability) {
        this.startResponse0(System.nanoTime(), System.currentTimeMillis(), updateAvailability);
    }

    private void startResponse0(long responseStartTimeNanos, long responseStartTimeMicros, boolean updateAvailability) {
        if (this.isAvailabilityAlreadyUpdated(RequestLogAvailability.RESPONSE_START)) {
            return;
        }
        this.responseStartTimeNanos = responseStartTimeNanos;
        this.responseStartTimeMicros = responseStartTimeMicros;
        if (updateAvailability) {
            this.updateAvailability(RequestLogAvailability.RESPONSE_START);
        }
    }

    @Override
    public long responseStartTimeMicros() {
        this.ensureAvailability(RequestLogAvailability.RESPONSE_START);
        return this.responseStartTimeMicros;
    }

    @Override
    public long responseStartTimeMillis() {
        return TimeUnit.MICROSECONDS.toMillis(this.responseStartTimeMicros());
    }

    @Override
    public long responseStartTimeNanos() {
        this.ensureAvailability(RequestLogAvailability.RESPONSE_START);
        return this.responseStartTimeNanos;
    }

    @Override
    public long responseEndTimeNanos() {
        this.ensureAvailability(RequestLogAvailability.RESPONSE_END);
        return this.responseEndTimeNanos;
    }

    @Override
    public long responseDurationNanos() {
        this.ensureAvailability(RequestLogAvailability.RESPONSE_END);
        return this.responseEndTimeNanos - this.responseStartTimeNanos;
    }

    @Override
    public Throwable responseCause() {
        this.ensureAvailability(RequestLogAvailability.RESPONSE_END);
        return this.responseCause;
    }

    @Override
    public long responseLength() {
        this.ensureAvailability(RequestLogAvailability.RESPONSE_END);
        return this.responseLength;
    }

    @Override
    public void responseLength(long responseLength) {
        if (responseLength < 0L) {
            throw new IllegalArgumentException("responseLength: " + responseLength + " (expected: >= 0)");
        }
        if (this.isAvailable(RequestLogAvailability.RESPONSE_END)) {
            return;
        }
        this.responseLength = responseLength;
    }

    @Override
    public void increaseResponseLength(long deltaBytes) {
        if (deltaBytes < 0L) {
            throw new IllegalArgumentException("deltaBytes: " + deltaBytes + " (expected: >= 0)");
        }
        if (this.isAvailable(RequestLogAvailability.RESPONSE_END)) {
            return;
        }
        this.responseLength += deltaBytes;
    }

    @Override
    public HttpHeaders responseHeaders() {
        this.ensureAvailability(RequestLogAvailability.RESPONSE_HEADERS);
        return this.responseHeaders;
    }

    @Override
    public void responseHeaders(HttpHeaders responseHeaders) {
        if (this.isAvailabilityAlreadyUpdated(RequestLogAvailability.RESPONSE_HEADERS)) {
            return;
        }
        this.responseHeaders = Objects.requireNonNull(responseHeaders, "responseHeaders");
        this.updateAvailability(RequestLogAvailability.RESPONSE_HEADERS);
    }

    @Override
    public Object responseContent() {
        this.ensureAvailability(RequestLogAvailability.RESPONSE_CONTENT);
        return this.responseContent;
    }

    @Override
    public void responseContent(@Nullable Object responseContent, @Nullable Object rawResponseContent) {
        if (this.isAvailabilityAlreadyUpdated(RequestLogAvailability.RESPONSE_CONTENT)) {
            return;
        }
        if (responseContent instanceof RpcResponse) {
            RpcResponse rpcResponse = (RpcResponse)responseContent;
            if (!rpcResponse.isDone()) {
                throw new IllegalArgumentException("responseContent must be complete: " + responseContent);
            }
            if (rpcResponse.cause() != null) {
                this.responseCause = rpcResponse.cause();
            }
        }
        this.responseContent = responseContent;
        this.rawResponseContent = rawResponseContent;
        this.updateAvailability(RequestLogAvailability.RESPONSE_CONTENT);
    }

    @Override
    public Object rawResponseContent() {
        this.ensureAvailability(RequestLogAvailability.RESPONSE_CONTENT);
        return this.rawResponseContent;
    }

    @Override
    public void deferResponseContent() {
        if (this.isAvailabilityAlreadyUpdated(RequestLogAvailability.RESPONSE_CONTENT)) {
            return;
        }
        this.responseContentDeferred = true;
    }

    @Override
    public boolean isResponseContentDeferred() {
        return this.responseContentDeferred;
    }

    @Override
    public void endResponse() {
        this.endResponse0(this.responseContent instanceof RpcResponse ? ((RpcResponse)this.responseContent).cause() : null);
    }

    @Override
    public void endResponse(Throwable responseCause) {
        this.endResponse0(Objects.requireNonNull(responseCause, "responseCause"));
    }

    private void endResponse0(@Nullable Throwable responseCause) {
        this.endResponse0(System.nanoTime(), responseCause);
    }

    private void endResponse0(long responseEndTimeNanos, @Nullable Throwable responseCause) {
        int flags;
        int n = flags = responseCause == null && this.responseContentDeferred ? FLAGS_RESPONSE_END_WITHOUT_CONTENT : RequestLogAvailability.RESPONSE_END.setterFlags();
        if (this.isAvailable(flags)) {
            return;
        }
        this.startResponse0(responseEndTimeNanos, DefaultRequestLog.currentTimeMicros(), false);
        this.responseEndTimeNanos = responseEndTimeNanos;
        if (this.responseCause == null) {
            this.responseCause = responseCause;
        }
        this.updateAvailability(flags);
    }

    @Override
    public long totalDurationNanos() {
        this.ensureAvailability(RequestLogAvailability.COMPLETE);
        return this.responseEndTimeNanos - this.requestStartTimeNanos;
    }

    private void updateAvailability(RequestLogAvailability a) {
        this.updateAvailability(a.setterFlags());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAvailability(int flags) {
        block4: {
            RequestLogListener[] satisfiedListeners;
            int newAvailability;
            int oldAvailability;
            while (!flagsUpdater.compareAndSet(this, oldAvailability = this.flags, newAvailability = oldAvailability | flags)) {
            }
            if (oldAvailability == newAvailability) break block4;
            List<ListenerEntry> list = this.listeners;
            synchronized (list) {
                satisfiedListeners = this.removeSatisfiedListeners();
            }
            this.notifyListeners(satisfiedListeners);
        }
    }

    @Nullable
    private RequestLogListener[] removeSatisfiedListeners() {
        if (this.listeners.isEmpty()) {
            return null;
        }
        int flags = this.flags;
        int maxNumListeners = this.listeners.size();
        Iterator<ListenerEntry> i = this.listeners.iterator();
        RequestLogListener[] satisfied = null;
        int numSatisfied = 0;
        do {
            ListenerEntry e = i.next();
            int interestedFlags = e.interestedFlags;
            if ((flags & interestedFlags) != interestedFlags) continue;
            i.remove();
            if (satisfied == null) {
                satisfied = new RequestLogListener[maxNumListeners];
            }
            satisfied[numSatisfied++] = e.listener;
        } while (i.hasNext());
        return satisfied;
    }

    private void notifyListeners(@Nullable RequestLogListener[] listeners) {
        if (listeners == null) {
            return;
        }
        for (RequestLogListener l : listeners) {
            if (l == null) break;
            RequestLogListenerInvoker.invokeOnRequestLog(l, this);
        }
    }

    public String toString() {
        String req = this.toStringRequestOnly();
        String res = this.toStringResponseOnly();
        StringBuilder buf = new StringBuilder(5 + req.length() + 6 + res.length() + 1);
        buf.append("{req=").append(req).append(", res=").append(res).append('}');
        if (this.children != null && this.children.size() > 1) {
            buf.append(", {totalAttempts=");
            buf.append(this.children.size());
            buf.append("}[");
            for (int i = 0; i < this.children.size(); ++i) {
                buf.append(this.children.get(i));
                if (i == this.children.size() - 1) continue;
                buf.append(", ");
            }
            buf.append(']');
        }
        return buf.toString();
    }

    @Override
    public String toStringRequestOnly() {
        return this.toStringRequestOnly(Function.identity(), Function.identity());
    }

    @Override
    public String toStringRequestOnly(Function<HttpHeaders, HttpHeaders> headersSanitizer, Function<Object, Object> contentSanitizer) {
        int flags = this.flags & 0xFFFF;
        if (this.requestStrFlags == flags) {
            return this.requestStr;
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append('{');
        if (DefaultRequestLog.isAvailable(flags, RequestLogAvailability.REQUEST_START)) {
            buf.append("startTime=");
            TextFormatter.appendEpoch(buf, this.requestStartTimeMillis());
            if (DefaultRequestLog.isAvailable(flags, RequestLogAvailability.REQUEST_END)) {
                buf.append(", length=");
                TextFormatter.appendSize(buf, this.requestLength);
                buf.append(", duration=");
                TextFormatter.appendElapsed(buf, this.requestDurationNanos());
                if (this.requestCause != null) {
                    buf.append(", cause=").append(this.requestCause);
                }
            }
            buf.append(", scheme=");
            if (DefaultRequestLog.isAvailable(flags, RequestLogAvailability.SCHEME)) {
                buf.append(this.scheme().uriText());
            } else {
                buf.append(SerializationFormat.UNKNOWN.uriText()).append('+').append(this.sessionProtocol.uriText());
            }
            buf.append(", host=").append(this.host);
            if (DefaultRequestLog.isAvailable(flags, RequestLogAvailability.REQUEST_HEADERS)) {
                buf.append(", headers=").append(headersSanitizer.apply(this.requestHeaders));
            }
            if (DefaultRequestLog.isAvailable(flags, RequestLogAvailability.REQUEST_CONTENT) && this.requestContent != null) {
                buf.append(", content=").append(contentSanitizer.apply(this.requestContent));
            }
        }
        buf.append('}');
        this.requestStr = buf.toString();
        this.requestStrFlags = flags;
        return this.requestStr;
    }

    @Override
    public String toStringResponseOnly() {
        return this.toStringResponseOnly(Function.identity(), Function.identity());
    }

    @Override
    public String toStringResponseOnly(Function<HttpHeaders, HttpHeaders> headersSanitizer, Function<Object, Object> contentSanitizer) {
        int flags = this.flags & 0xFFFF0000;
        if (this.responseStrFlags == flags) {
            return this.responseStr;
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append('{');
        if (DefaultRequestLog.isAvailable(flags, RequestLogAvailability.RESPONSE_START)) {
            buf.append("startTime=");
            TextFormatter.appendEpoch(buf, this.responseStartTimeMillis());
            if (DefaultRequestLog.isAvailable(flags, RequestLogAvailability.RESPONSE_END)) {
                buf.append(", length=");
                TextFormatter.appendSize(buf, this.responseLength);
                buf.append(", duration=");
                TextFormatter.appendElapsed(buf, this.responseDurationNanos());
                if (DefaultRequestLog.isAvailable(flags, RequestLogAvailability.REQUEST_START)) {
                    buf.append(", totalDuration=");
                    TextFormatter.appendElapsed(buf, this.totalDurationNanos());
                }
                if (this.responseCause != null) {
                    buf.append(", cause=").append(this.responseCause);
                }
            }
            if (DefaultRequestLog.isAvailable(flags, RequestLogAvailability.RESPONSE_HEADERS)) {
                buf.append(", headers=").append(headersSanitizer.apply(this.responseHeaders));
            }
            if (DefaultRequestLog.isAvailable(flags, RequestLogAvailability.RESPONSE_CONTENT) && this.responseContent != null) {
                buf.append(", content=").append(contentSanitizer.apply(this.responseContent));
            }
        }
        buf.append('}');
        this.responseStr = buf.toString();
        this.responseStrFlags = flags;
        return this.responseStr;
    }

    private static long currentTimeMicros() {
        if (PlatformDependent.javaVersion() == 8) {
            return TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis());
        }
        Instant now = Clock.systemUTC().instant();
        return TimeUnit.SECONDS.toMicros(now.getEpochSecond()) + TimeUnit.NANOSECONDS.toMicros(now.getNano());
    }

    private static final class ListenerEntry {
        final RequestLogListener listener;
        final int interestedFlags;

        ListenerEntry(RequestLogListener listener, int interestedFlags) {
            this.listener = listener;
            this.interestedFlags = interestedFlags;
        }
    }
}

