/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import javax.annotation.Nullable;
import org.slf4j.Logger;

public enum LogLevel {
    TRACE,
    DEBUG,
    INFO,
    WARN,
    ERROR;


    public boolean isEnabled(Logger logger) {
        switch (this) {
            case TRACE: {
                return logger.isTraceEnabled();
            }
            case DEBUG: {
                return logger.isDebugEnabled();
            }
            case INFO: {
                return logger.isInfoEnabled();
            }
            case WARN: {
                return logger.isWarnEnabled();
            }
            case ERROR: {
                return logger.isErrorEnabled();
            }
        }
        throw new Error();
    }

    public void log(Logger logger, String message) {
        switch (this) {
            case TRACE: {
                logger.trace(message);
                break;
            }
            case DEBUG: {
                logger.debug(message);
                break;
            }
            case INFO: {
                logger.info(message);
                break;
            }
            case WARN: {
                logger.warn(message);
                break;
            }
            case ERROR: {
                logger.error(message);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    public void log(Logger logger, String format, Object arg1) {
        switch (this) {
            case TRACE: {
                logger.trace(format, arg1);
                break;
            }
            case DEBUG: {
                logger.debug(format, arg1);
                break;
            }
            case INFO: {
                logger.info(format, arg1);
                break;
            }
            case WARN: {
                logger.warn(format, arg1);
                break;
            }
            case ERROR: {
                logger.error(format, arg1);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    public void log(Logger logger, String format, @Nullable Object arg1, @Nullable Object arg2) {
        switch (this) {
            case TRACE: {
                logger.trace(format, arg1, arg2);
                break;
            }
            case DEBUG: {
                logger.debug(format, arg1, arg2);
                break;
            }
            case INFO: {
                logger.info(format, arg1, arg2);
                break;
            }
            case WARN: {
                logger.warn(format, arg1, arg2);
                break;
            }
            case ERROR: {
                logger.error(format, arg1, arg2);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }
}

