/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.logging.LogLevel;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;
import java.util.function.Function;

public abstract class LoggingDecoratorBuilder<T extends LoggingDecoratorBuilder<T>> {
    private static final Function<HttpHeaders, HttpHeaders> DEFAULT_HEADERS_SANITIZER = Function.identity();
    private static final Function<Object, Object> DEFAULT_CONTENT_SANITIZER = Function.identity();
    private LogLevel requestLogLevel = LogLevel.TRACE;
    private LogLevel successfulResponseLogLevel = LogLevel.TRACE;
    private LogLevel failedResponseLogLevel = LogLevel.WARN;
    private Function<HttpHeaders, HttpHeaders> requestHeadersSanitizer = DEFAULT_HEADERS_SANITIZER;
    private Function<Object, Object> requestContentSanitizer = DEFAULT_CONTENT_SANITIZER;
    private Function<HttpHeaders, HttpHeaders> responseHeadersSanitizer = DEFAULT_HEADERS_SANITIZER;
    private Function<Object, Object> responseContentSanitizer = DEFAULT_CONTENT_SANITIZER;
    private float samplingRate = 1.0f;

    public T requestLogLevel(LogLevel requestLogLevel) {
        this.requestLogLevel = Objects.requireNonNull(requestLogLevel, "requestLogLevel");
        return this.unsafeCast(this);
    }

    protected LogLevel requestLogLevel() {
        return this.requestLogLevel;
    }

    public T successfulResponseLogLevel(LogLevel successfulResponseLogLevel) {
        this.successfulResponseLogLevel = Objects.requireNonNull(successfulResponseLogLevel, "successfulResponseLogLevel");
        return this.unsafeCast(this);
    }

    protected LogLevel successfulResponseLogLevel() {
        return this.successfulResponseLogLevel;
    }

    public T failureResponseLogLevel(LogLevel failedResponseLogLevel) {
        this.failedResponseLogLevel = Objects.requireNonNull(failedResponseLogLevel, "failedResponseLogLevel");
        return this.unsafeCast(this);
    }

    protected LogLevel failedResponseLogLevel() {
        return this.failedResponseLogLevel;
    }

    public T requestHeadersSanitizer(Function<HttpHeaders, HttpHeaders> requestHeadersSanitizer) {
        this.requestHeadersSanitizer = Objects.requireNonNull(requestHeadersSanitizer, "requestHeadersSanitizer");
        return this.unsafeCast(this);
    }

    protected Function<HttpHeaders, HttpHeaders> requestHeadersSanitizer() {
        return this.requestHeadersSanitizer;
    }

    public T requestContentSanitizer(Function<Object, Object> requestContentSanitizer) {
        this.requestContentSanitizer = Objects.requireNonNull(requestContentSanitizer, "requestContentSanitizer");
        return this.unsafeCast(this);
    }

    protected Function<Object, Object> requestContentSanitizer() {
        return this.requestContentSanitizer;
    }

    public T responseHeadersSanitizer(Function<HttpHeaders, HttpHeaders> responseHeadersSanitizer) {
        this.responseHeadersSanitizer = Objects.requireNonNull(responseHeadersSanitizer, "responseHeadersSanitizer");
        return this.unsafeCast(this);
    }

    protected Function<HttpHeaders, HttpHeaders> responseHeadersSanitizer() {
        return this.responseHeadersSanitizer;
    }

    public T responseContentSanitizer(Function<Object, Object> responseContentSanitizer) {
        this.responseContentSanitizer = Objects.requireNonNull(responseContentSanitizer, "responseContentSanitizer");
        return this.unsafeCast(this);
    }

    protected Function<Object, Object> responseContentSanitizer() {
        return this.responseContentSanitizer;
    }

    public T samplingRate(float samplingRate) {
        Preconditions.checkArgument(0.0 <= (double)samplingRate && (double)samplingRate <= 1.0, "samplingRate must be between 0.0 and 1.0");
        this.samplingRate = samplingRate;
        return this.unsafeCast(this);
    }

    protected float samplingRate() {
        return this.samplingRate;
    }

    private T unsafeCast(LoggingDecoratorBuilder<T> self) {
        return (T)self;
    }

    public String toString() {
        return LoggingDecoratorBuilder.toString(this, this.requestLogLevel, this.successfulResponseLogLevel, this.failedResponseLogLevel, this.requestHeadersSanitizer, this.requestContentSanitizer, this.responseHeadersSanitizer, this.responseContentSanitizer, this.samplingRate);
    }

    private static <T extends LoggingDecoratorBuilder<T>> String toString(LoggingDecoratorBuilder<T> self, LogLevel requestLogLevel, LogLevel successfulResponseLogLevel, LogLevel failureResponseLogLevel, Function<HttpHeaders, HttpHeaders> requestHeadersSanitizer, Function<Object, Object> requestContentSanitizer, Function<HttpHeaders, HttpHeaders> responseHeadersSanitizer, Function<Object, Object> responseContentSanitizer, float samplingRate) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(self).add("requestLogLevel", (Object)requestLogLevel).add("successfulResponseLogLevel", (Object)successfulResponseLogLevel).add("failedResponseLogLevel", (Object)failureResponseLogLevel).add("samplingRate", samplingRate);
        if (requestHeadersSanitizer != DEFAULT_HEADERS_SANITIZER) {
            helper.add("requestHeadersSanitizer", requestHeadersSanitizer);
        }
        if (requestContentSanitizer != DEFAULT_CONTENT_SANITIZER) {
            helper.add("requestContentSanitizer", requestContentSanitizer);
        }
        if (responseHeadersSanitizer != DEFAULT_HEADERS_SANITIZER) {
            helper.add("responseHeadersSanitizer", responseHeadersSanitizer);
        }
        if (responseContentSanitizer != DEFAULT_CONTENT_SANITIZER) {
            helper.add("responseContentSanitizer", responseContentSanitizer);
        }
        return helper.toString();
    }
}

