/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.common.logging.RequestLogAvailabilityException;
import com.linecorp.armeria.common.logging.RequestLogListener;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;

public interface RequestLog {
    public List<RequestLog> children();

    public Set<RequestLogAvailability> availabilities();

    public boolean isAvailable(RequestLogAvailability var1);

    default public boolean isAvailable(RequestLogAvailability ... availabilities) {
        for (RequestLogAvailability k : Objects.requireNonNull(availabilities, "availabilities")) {
            if (this.isAvailable(k)) continue;
            return false;
        }
        return true;
    }

    default public boolean isAvailable(Iterable<RequestLogAvailability> availabilities) {
        for (RequestLogAvailability k : Objects.requireNonNull(availabilities, "availabilities")) {
            if (this.isAvailable(k)) continue;
            return false;
        }
        return true;
    }

    default public void ensureAvailability(RequestLogAvailability availability) {
        if (!this.isAvailable(availability)) {
            throw new RequestLogAvailabilityException(availability.name());
        }
    }

    default public void ensureAvailability(RequestLogAvailability ... availabilities) {
        if (!this.isAvailable(availabilities)) {
            throw new RequestLogAvailabilityException(Arrays.toString((Object[])availabilities));
        }
    }

    default public void ensureAvailability(Iterable<RequestLogAvailability> properties) {
        if (!this.isAvailable(properties)) {
            throw new RequestLogAvailabilityException(properties.toString());
        }
    }

    public void addListener(RequestLogListener var1, RequestLogAvailability var2);

    public void addListener(RequestLogListener var1, RequestLogAvailability ... var2);

    public void addListener(RequestLogListener var1, Iterable<RequestLogAvailability> var2);

    public RequestContext context();

    default public HttpMethod method() {
        return this.context().method();
    }

    default public String path() {
        return this.context().path();
    }

    default public String decodedPath() {
        return this.context().decodedPath();
    }

    @Nullable
    default public String query() {
        return this.context().query();
    }

    public long requestStartTimeMicros();

    public long requestStartTimeMillis();

    public long requestStartTimeNanos();

    public long requestEndTimeNanos();

    public long requestDurationNanos();

    public long requestLength();

    @Nullable
    public Throwable requestCause();

    public long responseStartTimeMicros();

    public long responseStartTimeMillis();

    public long responseStartTimeNanos();

    public long responseEndTimeNanos();

    public long responseDurationNanos();

    public long responseLength();

    @Nullable
    public Throwable responseCause();

    public long totalDurationNanos();

    @Nullable
    public Channel channel();

    public SessionProtocol sessionProtocol();

    public SerializationFormat serializationFormat();

    public Scheme scheme();

    @Nullable
    @Deprecated
    default public String host() {
        RequestContext ctx = this.context();
        InetSocketAddress addr = ctx instanceof ClientRequestContext ? (InetSocketAddress)ctx.remoteAddress() : (InetSocketAddress)ctx.localAddress();
        return addr != null ? addr.getHostString() : null;
    }

    default public String authority() {
        String authority = this.requestHeaders().authority();
        if (!1.$assertionsDisabled && authority == null) {
            throw new AssertionError();
        }
        return authority;
    }

    default public HttpStatus status() {
        HttpStatus status = this.responseHeaders().status();
        if (!1.$assertionsDisabled && status == null) {
            throw new AssertionError();
        }
        return status;
    }

    default public int statusCode() {
        return this.status().code();
    }

    public HttpHeaders requestHeaders();

    @Nullable
    public Object requestContent();

    @Nullable
    public Object rawRequestContent();

    public HttpHeaders responseHeaders();

    @Nullable
    public Object responseContent();

    @Nullable
    public Object rawResponseContent();

    public String toStringRequestOnly();

    public String toStringRequestOnly(Function<HttpHeaders, HttpHeaders> var1, Function<Object, Object> var2);

    public String toStringResponseOnly();

    public String toStringResponseOnly(Function<HttpHeaders, HttpHeaders> var1, Function<Object, Object> var2);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

