/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.internal.shaded.fastutil.ints.Int2ObjectMap;
import com.linecorp.armeria.internal.shaded.fastutil.ints.Int2ObjectOpenHashMap;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterators;
import com.linecorp.armeria.internal.shaded.guava.math.IntMath;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

final class RequestLogAvailabilitySet
extends AbstractSet<RequestLogAvailability> {
    private static final RequestLogAvailability[] EMPTY_AVAILABILITIES = new RequestLogAvailability[0];
    private static final Int2ObjectMap<RequestLogAvailabilitySet> map = new Int2ObjectOpenHashMap<RequestLogAvailabilitySet>();
    private final int flags;
    private final RequestLogAvailability[] values;

    static RequestLogAvailabilitySet of(int flags) {
        RequestLogAvailabilitySet availabilities = (RequestLogAvailabilitySet)map.get(flags);
        assert (availabilities != null);
        return availabilities;
    }

    private RequestLogAvailabilitySet(int flags) {
        this.flags = flags;
        ArrayList<RequestLogAvailability> values = new ArrayList<RequestLogAvailability>();
        for (RequestLogAvailability v : RequestLogAvailability.values()) {
            if ((flags & v.getterFlags()) != v.getterFlags()) continue;
            values.add(v);
        }
        this.values = values.toArray(EMPTY_AVAILABILITIES);
    }

    @Override
    public Iterator<RequestLogAvailability> iterator() {
        return Iterators.forArray(this.values);
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public boolean contains(Object e) {
        if (!(e instanceof RequestLogAvailability)) {
            return false;
        }
        int flags = ((RequestLogAvailability)((Object)e)).getterFlags();
        return (this.flags & flags) == flags;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String toString() {
        return Arrays.toString((Object[])this.values);
    }

    static {
        RequestLogAvailability[] values = RequestLogAvailability.values();
        int end = IntMath.pow(2, values.length);
        for (int i = 0; i < end; ++i) {
            int flags = 0;
            for (RequestLogAvailability v : values) {
                if ((i & 1 << v.ordinal()) == 0) continue;
                flags |= v.setterFlags();
            }
            if (map.containsKey(flags)) continue;
            map.put(flags, new RequestLogAvailabilitySet(flags));
        }
    }
}

