/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.metric;

import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Lists;
import io.micrometer.core.instrument.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public final class MeterIdPrefix {
    private final String name;
    private final ImmutableList<Tag> tags;
    private int hashCode;

    public MeterIdPrefix(String name) {
        this(name, ImmutableList.of());
    }

    public MeterIdPrefix(String name, String ... tags) {
        this(name, MeterIdPrefix.zipAndSort(Objects.requireNonNull(tags, "tags")));
    }

    public MeterIdPrefix(String name, Iterable<Tag> tags) {
        this(name, MeterIdPrefix.copyAndSort(Objects.requireNonNull(tags, "tags")));
    }

    private MeterIdPrefix(String name, ImmutableList<Tag> tags) {
        this.name = Objects.requireNonNull(name, "name");
        this.tags = tags;
    }

    private static ImmutableList<Tag> zipAndSort(String ... tags) {
        if (tags.length == 0) {
            return ImmutableList.of();
        }
        ArrayList<Tag> result = new ArrayList<Tag>(tags.length / 2);
        MeterIdPrefix.zip(result, tags);
        return MeterIdPrefix.sort(result);
    }

    private static void zip(List<Tag> list, String ... tags) {
        Preconditions.checkArgument(tags.length % 2 == 0, "tags.length: %s (expected: even)", tags.length);
        int i = 0;
        while (i < tags.length) {
            list.add(Tag.of((String)tags[i++], (String)tags[i++]));
        }
    }

    private static ImmutableList<Tag> sort(List<Tag> tags) {
        if (tags.isEmpty()) {
            return ImmutableList.of();
        }
        tags.sort(Comparator.comparing(Tag::getKey));
        return ImmutableList.copyOf(tags);
    }

    private static ImmutableList<Tag> copyAndSort(Iterable<Tag> tags) {
        return MeterIdPrefix.sort(Lists.newArrayList(tags));
    }

    public String name() {
        return this.name;
    }

    public String name(String suffix) {
        Objects.requireNonNull(suffix, "suffix");
        return this.name + '.' + suffix;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public List<Tag> tags(String ... tags) {
        return this.sortedImmutableTags(tags);
    }

    public List<Tag> tags(Iterable<Tag> tags) {
        return this.sortedImmutableTags(tags);
    }

    private ImmutableList<Tag> sortedImmutableTags(String[] tags) {
        Objects.requireNonNull(tags, "tags");
        if (tags.length == 0) {
            return this.tags;
        }
        ArrayList<Tag> list = new ArrayList<Tag>(this.tags);
        MeterIdPrefix.zip(list, tags);
        return MeterIdPrefix.sort(list);
    }

    private ImmutableList<Tag> sortedImmutableTags(Iterable<Tag> tags) {
        Objects.requireNonNull(tags, "tags");
        if (tags instanceof Collection && ((Collection)tags).isEmpty()) {
            return this.tags;
        }
        ArrayList<Tag> list = new ArrayList<Tag>(this.tags);
        tags.forEach(list::add);
        return MeterIdPrefix.sort(list);
    }

    public MeterIdPrefix append(String suffix) {
        return new MeterIdPrefix(this.name(suffix), this.tags);
    }

    public MeterIdPrefix appendWithTags(String suffix, String ... tags) {
        return new MeterIdPrefix(this.name(suffix), this.sortedImmutableTags(tags));
    }

    public MeterIdPrefix appendWithTags(String suffix, Iterable<Tag> tags) {
        return new MeterIdPrefix(this.name(suffix), this.sortedImmutableTags(tags));
    }

    public MeterIdPrefix withTags(String ... tags) {
        return new MeterIdPrefix(this.name, this.sortedImmutableTags(tags));
    }

    public MeterIdPrefix withTags(Iterable<Tag> tags) {
        return new MeterIdPrefix(this.name, this.sortedImmutableTags(tags));
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.name.hashCode() * 31 + this.tags.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MeterIdPrefix)) {
            return false;
        }
        MeterIdPrefix that = (MeterIdPrefix)obj;
        return this.name.equals(that.name) && this.tags.equals(that.tags);
    }

    public String toString() {
        if (this.tags.isEmpty()) {
            return this.name;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.name).append('{');
        this.tags.forEach(tag -> buf.append(tag.getKey()).append('=').append(tag.getValue()).append(','));
        buf.setCharAt(buf.length() - 1, '}');
        return buf.toString();
    }
}

