/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.metric;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;

@FunctionalInterface
public interface MeterIdPrefixFunction {
    public static MeterIdPrefixFunction ofDefault(final String name) {
        Objects.requireNonNull(name, "name");
        return new MeterIdPrefixFunction(){

            @Override
            public MeterIdPrefix activeRequestPrefix(MeterRegistry registry, RequestLog log) {
                return new MeterIdPrefix(name, this.buildTags(log));
            }

            @Override
            public MeterIdPrefix apply(MeterRegistry registry, RequestLog log) {
                List<Tag> tags = this.buildTags(log);
                if (log.isAvailable(RequestLogAvailability.RESPONSE_HEADERS)) {
                    tags.add(Tag.of((String)"httpStatus", (String)log.status().codeAsText()));
                }
                return new MeterIdPrefix(name, tags);
            }

            private List<Tag> buildTags(RequestLog log) {
                HttpHeaders requestHeaders;
                HttpMethod httpMethod;
                RequestContext ctx = log.context();
                Object requestContent = log.requestContent();
                String methodName = null;
                if (requestContent instanceof RpcRequest) {
                    methodName = ((RpcRequest)requestContent).method();
                }
                if (methodName == null && (httpMethod = (requestHeaders = log.requestHeaders()).method()) != null) {
                    methodName = httpMethod.name();
                }
                if (methodName == null) {
                    methodName = MoreObjects.firstNonNull(log.method().name(), "__UNKNOWN_METHOD__");
                }
                ArrayList<Tag> tags = new ArrayList<Tag>(4);
                tags.add(Tag.of((String)"method", (String)methodName));
                if (ctx instanceof ServiceRequestContext) {
                    ServiceRequestContext sCtx = (ServiceRequestContext)ctx;
                    tags.add(Tag.of((String)"hostnamePattern", (String)sCtx.virtualHost().hostnamePattern()));
                    tags.add(Tag.of((String)"pathMapping", (String)sCtx.pathMapping().meterTag()));
                }
                return tags;
            }
        };
    }

    public MeterIdPrefix apply(MeterRegistry var1, RequestLog var2);

    default public MeterIdPrefix activeRequestPrefix(MeterRegistry registry, RequestLog log) {
        return this.apply(registry, log);
    }

    default public MeterIdPrefixFunction withTags(String ... keyValues) {
        Objects.requireNonNull(keyValues, "keyValues");
        return this.withTags((Iterable<Tag>)Tags.of((String[])keyValues));
    }

    default public MeterIdPrefixFunction withTags(Iterable<Tag> tags) {
        Objects.requireNonNull(tags, "tags");
        return this.andThen((registry, id) -> id.withTags(tags));
    }

    default public MeterIdPrefixFunction andThen(final BiFunction<MeterRegistry, MeterIdPrefix, MeterIdPrefix> function) {
        return new MeterIdPrefixFunction(){

            @Override
            public MeterIdPrefix activeRequestPrefix(MeterRegistry registry, RequestLog log) {
                return (MeterIdPrefix)function.apply(registry, MeterIdPrefixFunction.this.activeRequestPrefix(registry, log));
            }

            @Override
            public MeterIdPrefix apply(MeterRegistry registry, RequestLog log) {
                return (MeterIdPrefix)function.apply(registry, MeterIdPrefixFunction.this.apply(registry, log));
            }
        };
    }
}

