/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.metric;

import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class MoreMeters {
    private static final double[] PERCENTILES = new double[]{0.0, 0.5, 0.75, 0.9, 0.95, 0.98, 0.99, 0.999, 1.0};
    private static volatile DistributionStatisticConfig distStatCfg = DistributionStatisticConfig.builder().percentilesHistogram(Boolean.valueOf(false)).sla(new long[0]).percentiles(PERCENTILES).percentilePrecision(Integer.valueOf(2)).minimumExpectedValue(Long.valueOf(1L)).maximumExpectedValue(Long.valueOf(Long.MAX_VALUE)).expiry(Duration.ofMinutes(3L)).bufferLength(Integer.valueOf(3)).build();

    public static void setDistributionStatisticConfig(DistributionStatisticConfig config) {
        Objects.requireNonNull(config, "config");
        distStatCfg = config;
    }

    public static DistributionStatisticConfig distributionStatisticConfig() {
        return distStatCfg;
    }

    public static DistributionSummary newDistributionSummary(MeterRegistry registry, String name, Iterable<Tag> tags) {
        Objects.requireNonNull(registry, "registry");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(tags, "tags");
        return DistributionSummary.builder((String)name).tags(tags).publishPercentiles(distStatCfg.getPercentiles()).publishPercentileHistogram(distStatCfg.isPercentileHistogram()).maximumExpectedValue(distStatCfg.getMaximumExpectedValue()).minimumExpectedValue(distStatCfg.getMinimumExpectedValue()).distributionStatisticBufferLength(distStatCfg.getBufferLength()).distributionStatisticExpiry(distStatCfg.getExpiry()).sla(distStatCfg.getSlaBoundaries()).register(registry);
    }

    @Deprecated
    public static DistributionSummary summaryWithDefaultQuantiles(MeterRegistry registry, String name, Iterable<Tag> tags) {
        Objects.requireNonNull(registry, "registry");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(tags, "tags");
        return DistributionSummary.builder((String)name).tags(tags).publishPercentiles(PERCENTILES).register(registry);
    }

    public static Timer newTimer(MeterRegistry registry, String name, Iterable<Tag> tags) {
        Objects.requireNonNull(registry, "registry");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(tags, "tags");
        Duration maxExpectedValue = Optional.ofNullable(distStatCfg.getMaximumExpectedValue()).map(Duration::ofNanos).orElse(null);
        Duration minExpectedValue = Optional.ofNullable(distStatCfg.getMinimumExpectedValue()).map(Duration::ofNanos).orElse(null);
        return Timer.builder((String)name).tags(tags).maximumExpectedValue(maxExpectedValue).minimumExpectedValue(minExpectedValue).publishPercentiles(distStatCfg.getPercentiles()).publishPercentileHistogram(distStatCfg.isPercentileHistogram()).distributionStatisticBufferLength(distStatCfg.getBufferLength()).distributionStatisticExpiry(distStatCfg.getExpiry()).register(registry);
    }

    @Deprecated
    public static Timer timerWithDefaultQuantiles(MeterRegistry registry, String name, Iterable<Tag> tags) {
        Objects.requireNonNull(registry, "registry");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(tags, "tags");
        return Timer.builder((String)name).tags(tags).publishPercentiles(PERCENTILES).register(registry);
    }

    public static Map<String, Double> measureAll(MeterRegistry registry) {
        Objects.requireNonNull(registry, "registry");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        registry.forEachMeter(meter -> Streams.stream(meter.measure()).forEach(measurement -> {
            String fullName = MoreMeters.measurementName(meter.getId(), measurement);
            double value = measurement.getValue();
            builder.put(fullName, value);
        }));
        return builder.build();
    }

    private static String measurementName(Meter.Id id, Measurement measurement) {
        StringBuilder buf = new StringBuilder();
        buf.append(id.getName());
        buf.append('#');
        buf.append(measurement.getStatistic().getTagValueRepresentation());
        Iterator<Tag> tagsIterator = id.getTags().iterator();
        if (tagsIterator.hasNext()) {
            buf.append('{');
            tagsIterator.forEachRemaining(tag -> buf.append(tag.getKey()).append('=').append(tag.getValue()).append(','));
            buf.setCharAt(buf.length() - 1, '}');
        }
        return buf.toString();
    }

    private MoreMeters() {
    }
}

