/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.metric;

import com.linecorp.armeria.internal.shaded.guava.base.CaseFormat;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.config.NamingConvention;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class MoreNamingConventions {
    public static NamingConvention identity() {
        return (name, type, baseUnit) -> name;
    }

    public static NamingConvention dropwizard() {
        return MoreNamingConventions.identity();
    }

    public static NamingConvention prometheus() {
        return BetterPrometheusNamingConvention.INSTANCE;
    }

    public static void configure() {
        MoreNamingConventions.configure((MeterRegistry)Metrics.globalRegistry);
    }

    public static void configure(MeterRegistry registry) {
        Objects.requireNonNull(registry, "registry");
        if (registry instanceof CompositeMeterRegistry) {
            ((CompositeMeterRegistry)registry).getRegistries().forEach(MoreNamingConventions::configure);
        }
        if (MoreNamingConventions.registryTypeMatches(registry, "io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry")) {
            registry.config().namingConvention(MoreNamingConventions.dropwizard());
        } else if (MoreNamingConventions.registryTypeMatches(registry, "io.micrometer.prometheus.PrometheusMeterRegistry")) {
            registry.config().namingConvention(MoreNamingConventions.prometheus());
        }
    }

    private static boolean registryTypeMatches(MeterRegistry registry, String typeName) {
        try {
            Class<?> type = Class.forName(typeName, false, registry.getClass().getClassLoader());
            return type.isInstance(registry);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private MoreNamingConventions() {
    }

    private static final class BetterPrometheusNamingConvention
    implements NamingConvention {
        private static final Splitter NAME_SPLITTER = Splitter.on('.').omitEmptyStrings();
        private static final Pattern SANITIZE_PREFIX_PATTERN = Pattern.compile("^[^a-zA-Z_]");
        private static final Pattern SANITIZE_BODY_PATTERN = Pattern.compile("[^a-zA-Z0-9_]");
        private static final Pattern SANITIZE_LABEL_NAME_PREFIX_PATTERN = Pattern.compile("^[^a-zA-Z]+");
        private static final Pattern SANITIZE_LABEL_NAME_BODY_PATTERN = Pattern.compile("[^a-zA-Z0-9_]");
        private static final Pattern ALPHANUM_ONLY_PATTERN = Pattern.compile("^[a-zA-Z0-9]+$");
        private static final String SUFFIX_SECONDS = "seconds";
        private static final String SUFFIX_TOTAL = "total";
        private static final String RESERVED_LABEL_NAME_PREFIX = "__";
        private static final BetterPrometheusNamingConvention INSTANCE = new BetterPrometheusNamingConvention();

        private BetterPrometheusNamingConvention() {
        }

        public String name(String name, Meter.Type type, @Nullable String baseUnit) {
            StringBuilder buf = new StringBuilder();
            for (String n : NAME_SPLITTER.split(name)) {
                if (ALPHANUM_ONLY_PATTERN.matcher(n).matches()) {
                    buf.append(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, n));
                } else {
                    buf.append(n);
                }
                buf.append('_');
            }
            buf.setLength(buf.length() - 1);
            if (type == Meter.Type.TIMER) {
                baseUnit = SUFFIX_SECONDS;
            }
            if (!(baseUnit == null || buf.length() >= baseUnit.length() && buf.substring(buf.length() - baseUnit.length()).equalsIgnoreCase(baseUnit))) {
                buf.append('_').append(baseUnit);
            }
            if (!(type != Meter.Type.COUNTER || buf.length() >= SUFFIX_TOTAL.length() && buf.substring(buf.length() - SUFFIX_TOTAL.length()).equalsIgnoreCase(SUFFIX_TOTAL))) {
                buf.append('_').append(SUFFIX_TOTAL);
            }
            return SANITIZE_BODY_PATTERN.matcher(SANITIZE_PREFIX_PATTERN.matcher(buf.toString()).replaceFirst("_")).replaceAll("_");
        }

        public String tagKey(String key) {
            String sanitized = SANITIZE_LABEL_NAME_BODY_PATTERN.matcher(SANITIZE_LABEL_NAME_PREFIX_PATTERN.matcher(key).replaceFirst("_")).replaceAll("_");
            if (sanitized.startsWith(RESERVED_LABEL_NAME_PREFIX)) {
                return 'm' + sanitized;
            }
            return sanitized;
        }
    }
}

