/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.stream.AbstractStreamMessage;
import com.linecorp.armeria.common.stream.ClosedPublisherException;
import com.linecorp.armeria.common.stream.StreamMessageAndWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

abstract class AbstractStreamMessageAndWriter<T>
extends AbstractStreamMessage<T>
implements StreamMessageAndWriter<T> {
    AbstractStreamMessageAndWriter() {
    }

    @Override
    public boolean tryWrite(T obj) {
        Objects.requireNonNull(obj, "obj");
        if (obj instanceof ReferenceCounted) {
            ((ReferenceCounted)obj).touch();
            if (!(obj instanceof ByteBufHolder) && !(obj instanceof ByteBuf)) {
                throw new IllegalArgumentException("can't publish a ReferenceCounted that's not a ByteBuf or a ByteBufHolder: " + obj);
            }
        }
        if (!this.isOpen()) {
            ReferenceCountUtil.safeRelease(obj);
            return false;
        }
        this.addObject(obj);
        return true;
    }

    @Override
    public CompletableFuture<Void> onDemand(Runnable task) {
        Objects.requireNonNull(task, "task");
        AwaitDemandFuture f = new AwaitDemandFuture();
        if (!this.isOpen()) {
            f.completeExceptionally(ClosedPublisherException.get());
            return f;
        }
        this.addObjectOrEvent(f);
        return f.thenRun(task);
    }

    abstract void addObject(T var1);

    abstract void addObjectOrEvent(Object var1);

    static final class AwaitDemandFuture
    extends CompletableFuture<Void> {
        AwaitDemandFuture() {
        }
    }

    static enum State {
        OPEN,
        CLOSED,
        CLEANUP;

    }
}

