/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.stream.AbortingSubscriber;
import com.linecorp.armeria.common.stream.AbstractStreamMessage;
import com.linecorp.armeria.common.stream.DefaultStreamMessage;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.util.CompletionActions;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class DeferredStreamMessage<T>
extends AbstractStreamMessage<T> {
    private static final AtomicReferenceFieldUpdater<DeferredStreamMessage, AbstractStreamMessage.SubscriptionImpl> subscriptionUpdater = AtomicReferenceFieldUpdater.newUpdater(DeferredStreamMessage.class, AbstractStreamMessage.SubscriptionImpl.class, "subscription");
    private static final AtomicReferenceFieldUpdater<DeferredStreamMessage, StreamMessage> delegateUpdater = AtomicReferenceFieldUpdater.newUpdater(DeferredStreamMessage.class, StreamMessage.class, "delegate");
    private static final AtomicIntegerFieldUpdater<DeferredStreamMessage> subscribedToDelegateUpdater = AtomicIntegerFieldUpdater.newUpdater(DeferredStreamMessage.class, "subscribedToDelegate");
    private static final AtomicIntegerFieldUpdater<DeferredStreamMessage> abortPendingUpdater = AtomicIntegerFieldUpdater.newUpdater(DeferredStreamMessage.class, "abortPending");
    @Nullable
    private volatile StreamMessage<T> delegate;
    @Nullable
    private Subscription delegateSubscription;
    @Nullable
    private volatile AbstractStreamMessage.SubscriptionImpl subscription;
    private volatile int subscribedToDelegate;
    private long pendingDemand;
    private volatile int abortPending;
    private boolean cancelPending;

    protected void delegate(StreamMessage<T> delegate) {
        Objects.requireNonNull(delegate, "delegate");
        if (!delegateUpdater.compareAndSet(this, null, delegate)) {
            throw new IllegalStateException("delegate set already");
        }
        if (this.abortPending != 0) {
            delegate.abort();
        }
        if (!this.completionFuture().isDone()) {
            ((CompletableFuture)delegate.completionFuture().handle((unused, cause) -> {
                if (cause == null) {
                    this.completionFuture().complete(null);
                } else {
                    this.completionFuture().completeExceptionally((Throwable)cause);
                }
                return null;
            })).exceptionally(CompletionActions::log);
        }
        this.safeOnSubscribeToDelegate();
    }

    public void close() {
        DefaultStreamMessage m = new DefaultStreamMessage();
        m.close();
        this.delegate(m);
    }

    public void close(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        DefaultStreamMessage m = new DefaultStreamMessage();
        m.close(cause);
        this.delegate(m);
    }

    @Override
    public boolean isOpen() {
        StreamMessage<T> delegate = this.delegate;
        if (delegate != null) {
            return delegate.isOpen();
        }
        return !this.completionFuture().isDone();
    }

    @Override
    public boolean isEmpty() {
        StreamMessage<T> delegate = this.delegate;
        if (delegate != null) {
            return delegate.isEmpty();
        }
        return !this.isOpen();
    }

    @Override
    long demand() {
        return this.pendingDemand;
    }

    @Override
    void request(long n) {
        assert (this.subscription != null);
        if (this.subscription.needsDirectInvocation()) {
            this.doRequest(n);
        } else {
            this.subscription.executor().execute(() -> this.doRequest(n));
        }
    }

    private void doRequest(long n) {
        Subscription delegateSubscription = this.delegateSubscription;
        if (delegateSubscription != null) {
            delegateSubscription.request(n);
        } else {
            this.pendingDemand += n;
        }
    }

    @Override
    void cancel() {
        AbstractStreamMessage.SubscriptionImpl subscription = this.subscription;
        assert (subscription != null);
        if (subscription.needsDirectInvocation()) {
            this.doCancel();
        } else {
            subscription.executor().execute(this::doCancel);
        }
    }

    private void doCancel() {
        Subscription delegateSubscription = this.delegateSubscription;
        if (delegateSubscription != null) {
            try {
                delegateSubscription.cancel();
            }
            finally {
                StreamMessage<T> delegate = this.delegate;
                assert (delegate != null);
                if (delegate.isComplete()) {
                    this.subscription.clearSubscriber();
                } else {
                    delegate.completionFuture().whenComplete((u1, u2) -> this.subscription.clearSubscriber());
                }
            }
        } else {
            this.cancelPending = true;
        }
    }

    @Override
    void notifySubscriberOfCloseEvent(AbstractStreamMessage.SubscriptionImpl subscription, AbstractStreamMessage.CloseEvent event) {
    }

    @Override
    void subscribe(AbstractStreamMessage.SubscriptionImpl subscription) {
        Subscriber<Object> subscriber = subscription.subscriber();
        EventExecutor executor = subscription.executor();
        if (!subscriptionUpdater.compareAndSet(this, null, subscription)) {
            DeferredStreamMessage.failLateSubscriber(this.subscription, subscriber);
            return;
        }
        if (subscription.needsDirectInvocation()) {
            subscriber.onSubscribe((Subscription)subscription);
            this.safeOnSubscribeToDelegate();
        } else {
            executor.execute(() -> {
                subscriber.onSubscribe((Subscription)subscription);
                this.safeOnSubscribeToDelegate();
            });
        }
    }

    private void safeOnSubscribeToDelegate() {
        if (this.delegate == null || this.subscription == null) {
            return;
        }
        if (!subscribedToDelegateUpdater.compareAndSet(this, 0, 1)) {
            return;
        }
        this.delegate.subscribe(new ForwardingSubscriber(), this.subscription.executor(), this.subscription.withPooledObjects());
    }

    @Override
    public void abort() {
        if (!abortPendingUpdater.compareAndSet(this, 0, 1)) {
            return;
        }
        AbstractStreamMessage.SubscriptionImpl newSubscription = new AbstractStreamMessage.SubscriptionImpl(this, AbortingSubscriber.get(), (EventExecutor)ImmediateEventExecutor.INSTANCE, false);
        subscriptionUpdater.compareAndSet(this, null, newSubscription);
        StreamMessage<T> delegate = this.delegate;
        if (delegate != null) {
            delegate.abort();
        } else if (this.subscription.needsDirectInvocation()) {
            ABORTED_CLOSE.notifySubscriber(this.subscription, this.completionFuture());
        } else {
            this.subscription.executor().execute(() -> ABORTED_CLOSE.notifySubscriber(this.subscription, this.completionFuture()));
        }
    }

    private final class ForwardingSubscriber
    implements Subscriber<T> {
        private ForwardingSubscriber() {
        }

        public void onSubscribe(Subscription subscription) {
            DeferredStreamMessage.this.delegateSubscription = subscription;
            if (DeferredStreamMessage.this.cancelPending) {
                DeferredStreamMessage.this.delegateSubscription.cancel();
            } else if (DeferredStreamMessage.this.pendingDemand > 0L) {
                DeferredStreamMessage.this.delegateSubscription.request(DeferredStreamMessage.this.pendingDemand);
                DeferredStreamMessage.this.pendingDemand = 0L;
            }
        }

        public void onNext(T t) {
            DeferredStreamMessage.this.subscription.subscriber().onNext(t);
        }

        public void onError(Throwable t) {
            DeferredStreamMessage.this.subscription.subscriber().onError(t);
        }

        public void onComplete() {
            DeferredStreamMessage.this.subscription.subscriber().onComplete();
        }
    }
}

