/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.internal.PooledObjects;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FilteredStreamMessage<T, U>
implements StreamMessage<U> {
    private static final Logger logger = LoggerFactory.getLogger(FilteredStreamMessage.class);
    private final StreamMessage<T> delegate;
    private final boolean withPooledObjects;

    protected FilteredStreamMessage(StreamMessage<T> delegate) {
        this(delegate, false);
    }

    protected FilteredStreamMessage(StreamMessage<T> delegate, boolean withPooledObjects) {
        Objects.requireNonNull(delegate, "delegate");
        this.delegate = delegate;
        this.withPooledObjects = withPooledObjects;
    }

    protected abstract U filter(T var1);

    protected void beforeSubscribe(Subscriber<? super U> subscriber, Subscription subscription) {
    }

    protected void beforeComplete(Subscriber<? super U> subscriber) {
    }

    @Nullable
    protected Throwable beforeError(Subscriber<? super U> subscriber, Throwable cause) {
        return cause;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public CompletableFuture<Void> completionFuture() {
        return this.delegate.completionFuture();
    }

    @Override
    public void subscribe(Subscriber<? super U> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber");
        this.delegate.subscribe(new FilteringSubscriber(subscriber));
    }

    @Override
    public void subscribe(Subscriber<? super U> subscriber, boolean withPooledObjects) {
        Objects.requireNonNull(subscriber, "subscriber");
        this.delegate.subscribe(new FilteringSubscriber(subscriber), withPooledObjects);
    }

    @Override
    public void subscribe(Subscriber<? super U> subscriber, EventExecutor executor) {
        Objects.requireNonNull(subscriber, "subscriber");
        Objects.requireNonNull(executor, "executor");
        this.delegate.subscribe(new FilteringSubscriber(subscriber), executor);
    }

    @Override
    public void subscribe(Subscriber<? super U> subscriber, EventExecutor executor, boolean withPooledObjects) {
        Objects.requireNonNull(subscriber, "subscriber");
        Objects.requireNonNull(executor, "executor");
        this.delegate.subscribe(new FilteringSubscriber(subscriber), executor, withPooledObjects);
    }

    @Override
    public void abort() {
        this.delegate.abort();
    }

    private final class FilteringSubscriber
    implements Subscriber<T> {
        private final Subscriber<? super U> delegate;

        FilteringSubscriber(Subscriber<? super U> delegate) {
            Objects.requireNonNull(delegate, "delegate");
            this.delegate = delegate;
        }

        public void onSubscribe(Subscription s) {
            FilteredStreamMessage.this.beforeSubscribe(this.delegate, s);
            this.delegate.onSubscribe(s);
        }

        public void onNext(T o) {
            ReferenceCountUtil.touch(o);
            if (!FilteredStreamMessage.this.withPooledObjects) {
                o = PooledObjects.toUnpooled(o);
            }
            this.delegate.onNext(FilteredStreamMessage.this.filter(o));
        }

        public void onError(Throwable t) {
            Throwable filteredCause = FilteredStreamMessage.this.beforeError(this.delegate, t);
            if (filteredCause != null) {
                this.delegate.onError(filteredCause);
            } else {
                if (logger.isWarnEnabled()) {
                    logger.warn("{}#beforeError() returned null. Using the original exception: {}", (Object)FilteredStreamMessage.this.getClass().getName(), (Object)t.toString());
                }
                this.delegate.onError(t);
            }
        }

        public void onComplete() {
            FilteredStreamMessage.this.beforeComplete(this.delegate);
            this.delegate.onComplete();
        }
    }
}

