/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.common.stream.AbortingSubscriber;
import com.linecorp.armeria.common.stream.AbstractStreamMessage;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

abstract class FixedStreamMessage<T>
extends AbstractStreamMessage<T> {
    private static final AtomicReferenceFieldUpdater<FixedStreamMessage, AbstractStreamMessage.SubscriptionImpl> subscriptionUpdater = AtomicReferenceFieldUpdater.newUpdater(FixedStreamMessage.class, AbstractStreamMessage.SubscriptionImpl.class, "subscription");
    private static final AtomicReferenceFieldUpdater<FixedStreamMessage, AbstractStreamMessage.CloseEvent> closeEventUpdater = AtomicReferenceFieldUpdater.newUpdater(FixedStreamMessage.class, AbstractStreamMessage.CloseEvent.class, "closeEvent");
    @Nullable
    private volatile AbstractStreamMessage.SubscriptionImpl subscription;
    @Nullable
    private volatile AbstractStreamMessage.CloseEvent closeEvent;
    private int requested;

    FixedStreamMessage() {
    }

    abstract void cleanupObjects();

    abstract void doRequest(AbstractStreamMessage.SubscriptionImpl var1, long var2);

    @Nullable
    final AbstractStreamMessage.CloseEvent closeEvent() {
        return this.closeEvent;
    }

    final void cleanup(AbstractStreamMessage.SubscriptionImpl subscription) {
        AbstractStreamMessage.CloseEvent closeEvent = this.closeEvent;
        this.closeEvent = null;
        if (closeEvent != null) {
            this.notifySubscriberOfCloseEvent(subscription, closeEvent);
            return;
        }
        this.cleanupObjects();
    }

    final int requested() {
        return this.requested;
    }

    final void setRequested(int n) {
        this.requested = n;
    }

    @Override
    final void request(long n) {
        AbstractStreamMessage.SubscriptionImpl subscription = this.subscription;
        assert (subscription != null);
        if (subscription.needsDirectInvocation()) {
            this.doRequest(subscription, n);
        } else {
            subscription.executor().execute(() -> this.doRequest(subscription, n));
        }
    }

    @Override
    final long demand() {
        return this.requested;
    }

    @Override
    public final boolean isOpen() {
        return false;
    }

    @Override
    final void subscribe(AbstractStreamMessage.SubscriptionImpl subscription) {
        Subscriber<Object> subscriber = subscription.subscriber();
        EventExecutor executor = subscription.executor();
        if (!subscriptionUpdater.compareAndSet(this, null, subscription)) {
            FixedStreamMessage.failLateSubscriber(this.subscription, subscriber);
            return;
        }
        if (subscription.needsDirectInvocation()) {
            subscriber.onSubscribe((Subscription)subscription);
        } else {
            executor.execute(() -> subscriber.onSubscribe((Subscription)subscription));
        }
    }

    @Override
    final void notifySubscriberOfCloseEvent(AbstractStreamMessage.SubscriptionImpl subscription, AbstractStreamMessage.CloseEvent event) {
        try {
            event.notifySubscriber(subscription, this.completionFuture());
        }
        finally {
            subscription.clearSubscriber();
            this.cleanup(subscription);
        }
    }

    @Override
    final void cancel() {
        this.cancelOrAbort(true);
    }

    @Override
    public final void abort() {
        AbstractStreamMessage.SubscriptionImpl currentSubscription = this.subscription;
        if (currentSubscription != null) {
            this.cancelOrAbort(false);
            return;
        }
        AbstractStreamMessage.SubscriptionImpl newSubscription = new AbstractStreamMessage.SubscriptionImpl(this, AbortingSubscriber.get(), (EventExecutor)ImmediateEventExecutor.INSTANCE, false);
        subscriptionUpdater.compareAndSet(this, null, newSubscription);
        this.cancelOrAbort(false);
    }

    private void cancelOrAbort(boolean cancel) {
        AbstractStreamMessage.CloseEvent closeEvent;
        if (cancel) {
            closeEvent = Flags.verboseExceptions() ? new AbstractStreamMessage.CloseEvent(CancelledSubscriptionException.get()) : CANCELLED_CLOSE;
        } else {
            AbstractStreamMessage.CloseEvent closeEvent2 = closeEvent = Flags.verboseExceptions() ? new AbstractStreamMessage.CloseEvent(AbortedStreamException.get()) : ABORTED_CLOSE;
        }
        if (closeEventUpdater.compareAndSet(this, null, closeEvent)) {
            if (this.subscription.needsDirectInvocation()) {
                this.cleanup(this.subscription);
            } else {
                this.subscription.executor().execute(() -> this.cleanup(this.subscription));
            }
        }
    }
}

