/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.stream.AbstractStreamMessage;
import com.linecorp.armeria.common.stream.FixedStreamMessage;
import io.netty.util.ReferenceCountUtil;
import javax.annotation.Nullable;

public class OneElementFixedStreamMessage<T>
extends FixedStreamMessage<T> {
    @Nullable
    private T obj;

    protected OneElementFixedStreamMessage(T obj) {
        this.obj = obj;
    }

    @Override
    final void cleanupObjects() {
        if (this.obj != null) {
            try {
                this.onRemoval(this.obj);
            }
            finally {
                ReferenceCountUtil.safeRelease(this.obj);
            }
            this.obj = null;
        }
    }

    @Override
    final void doRequest(AbstractStreamMessage.SubscriptionImpl subscription, long unused) {
        if (this.requested() != 0) {
            return;
        }
        this.setRequested(1);
        this.doNotify(subscription);
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    private void doNotify(AbstractStreamMessage.SubscriptionImpl subscription) {
        assert (this.obj != null);
        T published = this.prepareObjectForNotification(subscription, this.obj);
        this.obj = null;
        subscription.subscriber().onNext(published);
        this.notifySubscriberOfCloseEvent(subscription, SUCCESSFUL_CLOSE);
    }
}

