/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.stream.AbstractStreamMessage;
import com.linecorp.armeria.common.stream.FixedStreamMessage;
import io.netty.util.ReferenceCountUtil;
import org.reactivestreams.Subscriber;

public class RegularFixedStreamMessage<T>
extends FixedStreamMessage<T> {
    private final T[] objs;
    private int fulfilled;
    private boolean inOnNext;

    protected RegularFixedStreamMessage(T[] objs) {
        this.objs = (Object[])objs.clone();
    }

    @Override
    final void cleanupObjects() {
        while (this.fulfilled < this.objs.length) {
            T obj = this.objs[this.fulfilled];
            this.objs[this.fulfilled++] = null;
            try {
                this.onRemoval(obj);
            }
            finally {
                ReferenceCountUtil.safeRelease(obj);
            }
        }
    }

    @Override
    final void doRequest(AbstractStreamMessage.SubscriptionImpl subscription, long n) {
        int oldDemand = this.requested();
        if (oldDemand >= this.objs.length) {
            return;
        }
        if (n >= (long)this.objs.length) {
            this.setRequested(this.objs.length);
        } else {
            this.setRequested((int)Math.min((long)oldDemand + n, (long)this.objs.length));
        }
        if (this.requested() > oldDemand) {
            this.doNotify(subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doNotify(AbstractStreamMessage.SubscriptionImpl subscription) {
        if (this.inOnNext) {
            return;
        }
        Subscriber<Object> subscriber = subscription.subscriber();
        block3: while (true) {
            if (this.closeEvent() != null) {
                this.cleanup(subscription);
                return;
            }
            if (this.fulfilled == this.objs.length) {
                this.notifySubscriberOfCloseEvent(subscription, SUCCESSFUL_CLOSE);
                return;
            }
            int requested = this.requested();
            if (this.fulfilled == requested) return;
            while (true) {
                if (this.fulfilled >= requested) continue block3;
                if (this.closeEvent() != null) {
                    this.cleanup(subscription);
                    return;
                }
                T o = this.objs[this.fulfilled];
                this.objs[this.fulfilled++] = null;
                o = this.prepareObjectForNotification(subscription, o);
                this.inOnNext = true;
                try {
                    subscriber.onNext(o);
                    continue;
                }
                finally {
                    this.inOnNext = false;
                    continue;
                }
                break;
            }
            break;
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

