/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.stream.EmptyFixedStreamMessage;
import com.linecorp.armeria.common.stream.OneElementFixedStreamMessage;
import com.linecorp.armeria.common.stream.RegularFixedStreamMessage;
import com.linecorp.armeria.common.stream.TwoElementFixedStreamMessage;
import io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public interface StreamMessage<T>
extends Publisher<T> {
    public static <T> StreamMessage<T> of() {
        return new EmptyFixedStreamMessage();
    }

    public static <T> StreamMessage<T> of(T obj) {
        Objects.requireNonNull(obj, "obj");
        return new OneElementFixedStreamMessage<T>(obj);
    }

    public static <T> StreamMessage<T> of(T obj1, T obj2) {
        Objects.requireNonNull(obj1, "obj1");
        Objects.requireNonNull(obj2, "obj2");
        return new TwoElementFixedStreamMessage<T>(obj1, obj2);
    }

    @SafeVarargs
    public static <T> StreamMessage<T> of(T ... objs) {
        Objects.requireNonNull(objs, "objs");
        switch (objs.length) {
            case 0: {
                return StreamMessage.of();
            }
            case 1: {
                return StreamMessage.of(objs[0]);
            }
            case 2: {
                return StreamMessage.of(objs[0], objs[1]);
            }
        }
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] != null) continue;
            throw new NullPointerException("objs[" + i + "] is null");
        }
        return new RegularFixedStreamMessage<T>(objs);
    }

    public boolean isOpen();

    public boolean isEmpty();

    default public boolean isComplete() {
        return this.completionFuture().isDone();
    }

    public CompletableFuture<Void> completionFuture();

    @Deprecated
    default public CompletableFuture<Void> closeFuture() {
        return this.completionFuture();
    }

    public void subscribe(Subscriber<? super T> var1);

    public void subscribe(Subscriber<? super T> var1, boolean var2);

    public void subscribe(Subscriber<? super T> var1, EventExecutor var2);

    public void subscribe(Subscriber<? super T> var1, EventExecutor var2, boolean var3);

    public void abort();
}

