/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.stream.ClosedPublisherException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;

public interface StreamWriter<T> {
    public boolean isOpen();

    default public void write(T o) {
        if (!this.tryWrite(o)) {
            throw ClosedPublisherException.get();
        }
    }

    default public void write(Supplier<? extends T> o) {
        if (!this.tryWrite(o)) {
            throw ClosedPublisherException.get();
        }
    }

    @CheckReturnValue
    public boolean tryWrite(T var1);

    @CheckReturnValue
    default public boolean tryWrite(Supplier<? extends T> o) {
        return this.tryWrite(o.get());
    }

    public CompletableFuture<Void> onDemand(Runnable var1);

    public void close();

    public void close(Throwable var1);

    default public void close(T obj) {
        this.write(obj);
        this.close();
    }
}

