/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.stream.AbstractStreamMessage;
import com.linecorp.armeria.common.stream.FixedStreamMessage;
import io.netty.util.ReferenceCountUtil;
import javax.annotation.Nullable;

public class TwoElementFixedStreamMessage<T>
extends FixedStreamMessage<T> {
    @Nullable
    private T obj1;
    @Nullable
    private T obj2;
    private boolean inOnNext;

    protected TwoElementFixedStreamMessage(T obj1, T obj2) {
        this.obj1 = obj1;
        this.obj2 = obj2;
    }

    @Override
    final void cleanupObjects() {
        if (this.obj1 != null) {
            try {
                this.onRemoval(this.obj1);
            }
            finally {
                ReferenceCountUtil.safeRelease(this.obj1);
            }
            this.obj1 = null;
        }
        if (this.obj2 != null) {
            try {
                this.onRemoval(this.obj2);
            }
            finally {
                ReferenceCountUtil.safeRelease(this.obj2);
            }
            this.obj2 = null;
        }
    }

    @Override
    final void doRequest(AbstractStreamMessage.SubscriptionImpl subscription, long n) {
        int oldDemand = this.requested();
        if (oldDemand >= 2) {
            return;
        }
        this.setRequested(n >= 2L ? oldDemand + 2 : oldDemand + 1);
        this.doNotify(subscription);
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    private void doNotify(AbstractStreamMessage.SubscriptionImpl subscription) {
        if (this.inOnNext) {
            return;
        }
        if (this.obj1 != null) {
            try {
                this.doNotifyObject(subscription, this.obj1);
            }
            finally {
                this.obj1 = null;
            }
        }
        if (this.requested() >= 2 && this.obj2 != null) {
            try {
                this.doNotifyObject(subscription, this.obj2);
            }
            finally {
                this.obj2 = null;
            }
            this.notifySubscriberOfCloseEvent(subscription, SUCCESSFUL_CLOSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotifyObject(AbstractStreamMessage.SubscriptionImpl subscription, T obj) {
        T published = this.prepareObjectForNotification(subscription, obj);
        this.inOnNext = true;
        try {
            subscription.subscriber().onNext(published);
        }
        finally {
            this.inOnNext = false;
        }
    }
}

