/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.common.util.Listenable;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;

public abstract class AbstractListenable<T>
implements Listenable<T> {
    private final Set<Consumer<? super T>> updateListeners = new CopyOnWriteArraySet<Consumer<? super T>>();

    protected final void notifyListeners(T latestValue) {
        for (Consumer<T> listener : this.updateListeners) {
            listener.accept(latestValue);
        }
    }

    @Override
    public final void addListener(Consumer<? super T> listener) {
        Objects.requireNonNull(listener, "listener");
        this.updateListeners.add(listener);
    }

    @Override
    public final void removeListener(Consumer<?> listener) {
        Objects.requireNonNull(listener, "listener");
        this.updateListeners.remove(listener);
    }
}

