/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.internal.TransportType;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;

public final class EventLoopGroups {
    public static EventLoopGroup newEventLoopGroup(int numThreads) {
        return EventLoopGroups.newEventLoopGroup(numThreads, false);
    }

    public static EventLoopGroup newEventLoopGroup(int numThreads, boolean useDaemonThreads) {
        return EventLoopGroups.newEventLoopGroup(numThreads, "armeria-eventloop", useDaemonThreads);
    }

    public static EventLoopGroup newEventLoopGroup(int numThreads, String threadNamePrefix) {
        return EventLoopGroups.newEventLoopGroup(numThreads, threadNamePrefix, false);
    }

    public static EventLoopGroup newEventLoopGroup(int numThreads, String threadNamePrefix, boolean useDaemonThreads) {
        Preconditions.checkArgument(numThreads > 0, "numThreads: %s (expected: > 0)", numThreads);
        Objects.requireNonNull(threadNamePrefix, "threadNamePrefix");
        TransportType type = TransportType.detectTransportType();
        String prefix = threadNamePrefix + '-' + type.lowerCasedName();
        return EventLoopGroups.newEventLoopGroup(numThreads, (ThreadFactory)new DefaultThreadFactory(prefix, useDaemonThreads));
    }

    public static EventLoopGroup newEventLoopGroup(int numThreads, ThreadFactory threadFactory) {
        Preconditions.checkArgument(numThreads > 0, "numThreads: %s (expected: > 0)", numThreads);
        Objects.requireNonNull(threadFactory, "threadFactory");
        TransportType type = TransportType.detectTransportType();
        return type.newEventLoopGroup(numThreads, unused -> threadFactory);
    }

    private EventLoopGroups() {
    }
}

