/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.shaded.futures.CompletableFutures;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StartStopSupport<V, L>
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(StartStopSupport.class);
    private final Executor executor;
    private final List<L> listeners = new CopyOnWriteArrayList<L>();
    private volatile State state = State.STOPPED;
    private CompletableFuture<?> future = CompletableFuture.completedFuture(null);

    protected StartStopSupport(Executor executor) {
        this.executor = Objects.requireNonNull(executor, "executor");
    }

    public final void addListener(L listener) {
        this.listeners.add(Objects.requireNonNull(listener, "listener"));
    }

    public final boolean removeListener(L listener) {
        return this.listeners.remove(Objects.requireNonNull(listener, "listener"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized CompletableFuture<V> start(boolean failIfStarted) {
        switch (this.state) {
            case STARTING: 
            case STARTED: {
                if (failIfStarted) {
                    return CompletableFutures.exceptionallyCompletedFuture(new IllegalStateException("must be stopped to start; currently " + (Object)((Object)this.state)));
                }
                CompletableFuture<?> castFuture = this.future;
                return castFuture;
            }
            case STOPPING: {
                return ((CompletableFuture)this.future.exceptionally(unused -> null)).thenComposeAsync(unused -> this.start(failIfStarted), this.executor);
            }
        }
        assert (this.state == State.STOPPED) : "state: " + (Object)((Object)this.state);
        this.state = State.STARTING;
        CompletableFuture startFuture = new CompletableFuture();
        boolean submitted = false;
        try {
            this.executor.execute(() -> {
                try {
                    this.notifyListeners(State.STARTING, null);
                    CompletionStage<V> f = this.doStart();
                    if (f == null) {
                        throw new IllegalStateException("doStart() returned null.");
                    }
                    f.whenComplete((result, cause) -> {
                        if (cause != null) {
                            startFuture.completeExceptionally((Throwable)cause);
                        } else {
                            startFuture.complete(result);
                        }
                    });
                }
                catch (Exception e) {
                    startFuture.completeExceptionally(e);
                }
            });
            submitted = true;
        }
        catch (Exception e) {
            CompletableFuture completableFuture = CompletableFutures.exceptionallyCompletedFuture(e);
            return completableFuture;
        }
        finally {
            if (!submitted) {
                this.state = State.STOPPED;
            }
        }
        CompletionStage future = ((CompletableFuture)startFuture.handleAsync((result, cause) -> {
            if (cause != null) {
                CompletionStage rollbackFuture = this.stop(true).exceptionally(stopCause -> {
                    this.rollbackFailed(Exceptions.peel(stopCause));
                    return null;
                });
                return ((CompletableFuture)rollbackFuture).thenCompose(unused -> CompletableFutures.exceptionallyCompletedFuture(cause));
            }
            this.enter(State.STARTED, result);
            return CompletableFuture.completedFuture(result);
        }, this.executor)).thenCompose(Function.identity());
        this.future = future;
        return future;
    }

    public final CompletableFuture<Void> stop() {
        return this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized CompletableFuture<Void> stop(boolean rollback) {
        switch (this.state) {
            case STARTING: {
                if (rollback) break;
                return ((CompletableFuture)this.future.exceptionally(unused -> null)).thenComposeAsync(unused -> this.stop(), this.executor);
            }
            case STOPPING: 
            case STOPPED: {
                CompletableFuture<Void> castFuture = this.future;
                return castFuture;
            }
        }
        assert (this.state == State.STARTED || rollback) : "state: " + (Object)((Object)this.state) + ", rollback: " + rollback;
        State oldState = this.state;
        this.state = State.STOPPING;
        CompletableFuture stopFuture = new CompletableFuture();
        boolean submitted = false;
        try {
            this.executor.execute(() -> {
                try {
                    this.notifyListeners(State.STOPPING, null);
                    CompletionStage<Void> f = this.doStop();
                    if (f == null) {
                        throw new IllegalStateException("doStop() returned null.");
                    }
                    f.whenComplete((unused, cause) -> {
                        if (cause != null) {
                            stopFuture.completeExceptionally((Throwable)cause);
                        } else {
                            stopFuture.complete(null);
                        }
                    });
                }
                catch (Exception e) {
                    stopFuture.completeExceptionally(e);
                }
            });
            submitted = true;
        }
        catch (Exception e) {
            CompletableFuture<Void> completableFuture = CompletableFutures.exceptionallyCompletedFuture(e);
            return completableFuture;
        }
        finally {
            if (!submitted) {
                this.state = oldState;
            }
        }
        CompletionStage future = stopFuture.whenCompleteAsync((unused1, unused2) -> this.enter(State.STOPPED, null), this.executor);
        this.future = future;
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        CompletableFuture<Void> f;
        StartStopSupport startStopSupport = this;
        synchronized (startStopSupport) {
            if (this.state == State.STOPPED) {
                return;
            }
            f = this.stop();
        }
        boolean interrupted = false;
        while (true) {
            try {
                f.get();
            }
            catch (InterruptedException ignored) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                this.closeFailed(Exceptions.peel(e));
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enter(State state, @Nullable V value) {
        StartStopSupport startStopSupport = this;
        synchronized (startStopSupport) {
            assert (this.state != state) : "transition to the same state: " + (Object)((Object)state);
            this.state = state;
        }
        this.notifyListeners(state, value);
    }

    private void notifyListeners(State state, @Nullable V value) {
        for (L l : this.listeners) {
            try {
                switch (state) {
                    case STARTING: {
                        this.notifyStarting(l);
                        break;
                    }
                    case STARTED: {
                        this.notifyStarted(l, value);
                        break;
                    }
                    case STOPPING: {
                        this.notifyStopping(l);
                        break;
                    }
                    case STOPPED: {
                        this.notifyStopped(l);
                        break;
                    }
                    default: {
                        throw new Error("unknown state: " + (Object)((Object)state));
                    }
                }
            }
            catch (Exception cause) {
                this.notificationFailed(l, cause);
            }
        }
    }

    protected abstract CompletionStage<V> doStart() throws Exception;

    protected abstract CompletionStage<Void> doStop() throws Exception;

    protected void notifyStarting(L listener) throws Exception {
    }

    protected void notifyStarted(L listener, @Nullable V value) throws Exception {
    }

    protected void notifyStopping(L listener) throws Exception {
    }

    protected void notifyStopped(L listener) throws Exception {
    }

    protected void rollbackFailed(Throwable cause) {
        StartStopSupport.logStopFailure(cause);
    }

    protected void notificationFailed(L listener, Throwable cause) {
        logger.warn("Failed to notify a listener: {}", listener, (Object)cause);
    }

    protected void closeFailed(Throwable cause) {
        StartStopSupport.logStopFailure(cause);
    }

    private static void logStopFailure(Throwable cause) {
        logger.warn("Failed to stop: {}", (Object)cause.getMessage(), (Object)cause);
    }

    public String toString() {
        return this.state.name();
    }

    static enum State {
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

