/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.util.Exceptions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import javax.annotation.Nullable;

public abstract class AbstractHttp2ConnectionHandler
extends Http2ConnectionHandler {
    private static final Http2StreamVisitor closeAllStreams = stream -> {
        if (stream.state() != Http2Stream.State.CLOSED) {
            stream.close();
        }
        return true;
    };
    private boolean closing;
    private boolean handlingConnectionError;

    protected AbstractHttp2ConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
        super(decoder, encoder, initialSettings);
    }

    public boolean isClosing() {
        return this.closing;
    }

    protected void onConnectionError(ChannelHandlerContext ctx, boolean outbound, Throwable cause, Http2Exception http2Ex) {
        if (this.handlingConnectionError) {
            return;
        }
        this.handlingConnectionError = true;
        super.onConnectionError(ctx, outbound, cause, AbstractHttp2ConnectionHandler.filterHttp2Exception(cause, http2Ex));
    }

    private static Http2Exception filterHttp2Exception(Throwable cause, @Nullable Http2Exception http2Ex) {
        if (http2Ex != null) {
            return http2Ex;
        }
        if (Flags.verboseResponses()) {
            return new Http2Exception(Http2Error.INTERNAL_ERROR, AbstractHttp2ConnectionHandler.goAwayDebugData(null, cause), cause);
        }
        return new Http2Exception(Http2Error.INTERNAL_ERROR, null, cause);
    }

    private static String goAwayDebugData(@Nullable Http2Exception http2Ex, @Nullable Throwable cause) {
        String message;
        String type;
        if (http2Ex != null) {
            type = http2Ex.getClass().getName();
            message = http2Ex.getMessage();
        } else {
            type = null;
            message = null;
            if (cause == null) {
                return "";
            }
        }
        StringBuilder buf = new StringBuilder(256);
        if (type != null) {
            buf.append(", type: ");
            buf.append(type);
        }
        if (message != null) {
            buf.append(", message: ");
            buf.append(message);
        }
        if (cause != null) {
            buf.append(", cause: ");
            buf.append(Exceptions.traceText(cause));
        }
        return buf.substring(2);
    }

    public ChannelFuture goAway(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData, ChannelPromise promise) {
        if (!ctx.channel().isActive()) {
            promise.unvoid().trySuccess();
            debugData.release();
            return promise;
        }
        return super.goAway(ctx, lastStreamId, errorCode, debugData, promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        if (!this.closing) {
            this.closing = true;
            if (this.needsImmediateDisconnection()) {
                this.connection().forEachActiveStream(closeAllStreams);
            }
            this.onCloseRequest(ctx);
        }
        super.close(ctx, promise);
    }

    protected abstract void onCloseRequest(ChannelHandlerContext var1) throws Exception;

    protected abstract boolean needsImmediateDisconnection();
}

