/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal;

import com.linecorp.armeria.common.DefaultHttpHeaders;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.HttpStatusClass;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Caffeine;
import com.linecorp.armeria.internal.shaded.caffeine.cache.LoadingCache;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.UnsupportedValueConverter;
import io.netty.handler.codec.ValueConverter;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.Nullable;

public final class ArmeriaHttpUtil {
    public static final HashingStrategy<AsciiString> HTTP2_HEADER_NAME_HASHER = new HashingStrategy<AsciiString>(){

        public int hashCode(AsciiString o) {
            return o.hashCode();
        }

        public boolean equals(AsciiString a, AsciiString b) {
            return a.contentEqualsIgnoreCase((CharSequence)b);
        }
    };
    private static final URI ROOT = URI.create("/");
    private static final CharSequenceMap HTTP_TO_HTTP2_HEADER_BLACKLIST = new CharSequenceMap();
    private static final CharSequenceMap HTTP2_TO_HTTP_HEADER_BLACKLIST = new CharSequenceMap();
    private static final CharSequenceMap REQUEST_HEADER_TRANSLATIONS;
    private static final CharSequenceMap RESPONSE_HEADER_TRANSLATIONS;
    private static final String EMPTY_REQUEST_PATH = "/";
    private static final Splitter COOKIE_SPLITTER;
    private static final String COOKIE_SEPARATOR = "; ";
    @Nullable
    private static final LoadingCache<AsciiString, String> HEADER_VALUE_CACHE;
    private static final Set<AsciiString> CACHED_HEADERS;

    private static LoadingCache<AsciiString, String> buildCache(String spec) {
        return Caffeine.from(spec).build(AsciiString::toString);
    }

    public static String concatPaths(@Nullable String path1, @Nullable String path2) {
        String string = path2 = path2 == null ? "" : path2;
        if (path1 == null || path1.isEmpty() || EMPTY_REQUEST_PATH.equals(path1)) {
            if (path2.isEmpty()) {
                return EMPTY_REQUEST_PATH;
            }
            if (path2.charAt(0) == '/') {
                return path2;
            }
            return new StringBuilder(path2.length() + 1).append('/').append(path2).toString();
        }
        if (path2.isEmpty()) {
            return path1;
        }
        if (path1.charAt(path1.length() - 1) == '/') {
            if (path2.charAt(0) == '/') {
                return new StringBuilder(path1.length() + path2.length() - 1).append(path1).append(path2, 1, path2.length()).toString();
            }
            return new StringBuilder(path1.length() + path2.length()).append(path1).append(path2).toString();
        }
        if (path2.charAt(0) == '/') {
            return path1 + path2;
        }
        return new StringBuilder(path1.length() + path2.length() + 1).append(path1).append('/').append(path2).toString();
    }

    public static String decodePath(String path) {
        if (path.indexOf(37) < 0) {
            return path;
        }
        int len = path.length();
        byte[] buf = new byte[len];
        int dstLen = 0;
        for (int i = 0; i < len; ++i) {
            int ch = path.charAt(i);
            if (ch != 37) {
                buf[dstLen++] = (byte)((ch & 0xFF80) == 0 ? ch : 255);
                continue;
            }
            int hexEnd = i + 3;
            if (hexEnd > len) {
                buf[dstLen++] = -1;
                break;
            }
            int digit1 = StringUtil.decodeHexNibble((char)path.charAt(++i));
            int digit2 = StringUtil.decodeHexNibble((char)path.charAt(++i));
            buf[dstLen++] = digit1 < 0 || digit2 < 0 ? -1 : (byte)(digit1 << 4 | digit2);
        }
        return new String(buf, 0, dstLen, StandardCharsets.UTF_8);
    }

    public static boolean isContentAlwaysEmpty(HttpStatus status) {
        if (status.codeClass() == HttpStatusClass.INFORMATIONAL) {
            return true;
        }
        switch (status.code()) {
            case 204: 
            case 205: 
            case 304: {
                return true;
            }
        }
        return false;
    }

    public static boolean isContentAlwaysEmptyWithValidation(HttpStatus status, HttpData content, HttpHeaders trailingHeaders) {
        if (!ArmeriaHttpUtil.isContentAlwaysEmpty(status)) {
            return false;
        }
        if (!content.isEmpty()) {
            throw new IllegalArgumentException("A " + status + " response must have empty content: " + content.length() + " byte(s)");
        }
        if (!trailingHeaders.isEmpty()) {
            throw new IllegalArgumentException("A " + status + " response must not have trailing headers: " + trailingHeaders);
        }
        return true;
    }

    public static HttpHeaders toArmeria(Http2Headers headers, boolean endOfStream) {
        DefaultHttpHeaders converted = new DefaultHttpHeaders(false, headers.size(), endOfStream);
        StringJoiner cookieJoiner = null;
        for (Map.Entry e : headers) {
            AsciiString name = AsciiString.of((CharSequence)((CharSequence)e.getKey()));
            CharSequence value = (CharSequence)e.getValue();
            if (name.equals((Object)HttpHeaderNames.COOKIE)) {
                if (cookieJoiner == null) {
                    cookieJoiner = new StringJoiner(COOKIE_SEPARATOR);
                }
                COOKIE_SPLITTER.split(value).forEach(cookieJoiner::add);
                continue;
            }
            converted.add(name, ArmeriaHttpUtil.convertHeaderValue(name, value));
        }
        if (cookieJoiner != null && cookieJoiner.length() != 0) {
            converted.add(HttpHeaderNames.COOKIE, cookieJoiner.toString());
        }
        return converted;
    }

    public static HttpHeaders toArmeria(HttpRequest in) throws URISyntaxException {
        URI requestTargetUri = ArmeriaHttpUtil.toUri(in);
        io.netty.handler.codec.http.HttpHeaders inHeaders = in.headers();
        DefaultHttpHeaders out = new DefaultHttpHeaders(true, inHeaders.size());
        out.path(ArmeriaHttpUtil.toHttp2Path(requestTargetUri));
        out.method(HttpMethod.valueOf(in.method().name()));
        ArmeriaHttpUtil.setHttp2Scheme(inHeaders, requestTargetUri, out);
        if (!HttpUtil.isOriginForm((URI)requestTargetUri) && !HttpUtil.isAsteriskForm((URI)requestTargetUri)) {
            String host = inHeaders.getAsString((CharSequence)HttpHeaderNames.HOST);
            ArmeriaHttpUtil.setHttp2Authority(host == null || host.isEmpty() ? requestTargetUri.getAuthority() : host, out);
        }
        ArmeriaHttpUtil.toArmeria(inHeaders, out);
        return out;
    }

    public static HttpHeaders toArmeria(HttpResponse in) {
        io.netty.handler.codec.http.HttpHeaders inHeaders = in.headers();
        DefaultHttpHeaders out = new DefaultHttpHeaders(true, inHeaders.size());
        out.status(in.status().code());
        ArmeriaHttpUtil.toArmeria(inHeaders, out);
        return out;
    }

    public static HttpHeaders toArmeria(io.netty.handler.codec.http.HttpHeaders inHeaders) {
        if (inHeaders.isEmpty()) {
            return HttpHeaders.EMPTY_HEADERS;
        }
        DefaultHttpHeaders out = new DefaultHttpHeaders(true, inHeaders.size());
        ArmeriaHttpUtil.toArmeria(inHeaders, out);
        return out;
    }

    public static void toArmeria(io.netty.handler.codec.http.HttpHeaders inHeaders, HttpHeaders out) {
        Iterator iter2 = inHeaders.iteratorCharSequence();
        CharSequenceMap connectionBlacklist = ArmeriaHttpUtil.toLowercaseMap(inHeaders.valueCharSequenceIterator((CharSequence)HttpHeaderNames.CONNECTION), 8);
        StringJoiner cookieJoiner = null;
        while (iter2.hasNext()) {
            Map.Entry entry = (Map.Entry)iter2.next();
            AsciiString aName = AsciiString.of((CharSequence)((CharSequence)entry.getKey())).toLowerCase();
            if (HTTP_TO_HTTP2_HEADER_BLACKLIST.contains(aName) || connectionBlacklist.contains(aName)) continue;
            if (aName.equals((Object)HttpHeaderNames.TE)) {
                ArmeriaHttpUtil.toHttp2HeadersFilterTE(entry, out);
                continue;
            }
            CharSequence value = (CharSequence)entry.getValue();
            if (aName.equals((Object)HttpHeaderNames.COOKIE)) {
                if (cookieJoiner == null) {
                    cookieJoiner = new StringJoiner(COOKIE_SEPARATOR);
                }
                COOKIE_SPLITTER.split(value).forEach(cookieJoiner::add);
                continue;
            }
            out.add(aName, ArmeriaHttpUtil.convertHeaderValue(aName, value));
        }
        if (cookieJoiner != null && cookieJoiner.length() != 0) {
            out.add(HttpHeaderNames.COOKIE, cookieJoiner.toString());
        }
    }

    private static CharSequenceMap toLowercaseMap(Iterator<? extends CharSequence> valuesIter, int arraySizeHint) {
        CharSequenceMap result = new CharSequenceMap(arraySizeHint);
        while (valuesIter.hasNext()) {
            AsciiString lowerCased = AsciiString.of((CharSequence)valuesIter.next()).toLowerCase();
            try {
                int index = lowerCased.forEachByte(ByteProcessor.FIND_COMMA);
                if (index != -1) {
                    int start = 0;
                    do {
                        result.add(lowerCased.subSequence(start, index, false).trim(), AsciiString.EMPTY_STRING);
                    } while ((start = index + 1) < lowerCased.length() && (index = lowerCased.forEachByte(start, lowerCased.length() - start, ByteProcessor.FIND_COMMA)) != -1);
                    result.add(lowerCased.subSequence(start, lowerCased.length(), false).trim(), AsciiString.EMPTY_STRING);
                    continue;
                }
                result.add(lowerCased.trim(), AsciiString.EMPTY_STRING);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return result;
    }

    private static void toHttp2HeadersFilterTE(Map.Entry<CharSequence, CharSequence> entry, HttpHeaders out) {
        block2: {
            block1: {
                if (AsciiString.indexOf((CharSequence)entry.getValue(), (char)',', (int)0) != -1) break block1;
                if (!AsciiString.contentEqualsIgnoreCase((CharSequence)AsciiString.trim((CharSequence)entry.getValue()), (CharSequence)HttpHeaderValues.TRAILERS)) break block2;
                out.add(HttpHeaderNames.TE, HttpHeaderValues.TRAILERS.toString());
                break block2;
            }
            List teValues = StringUtil.unescapeCsvFields((CharSequence)entry.getValue());
            for (CharSequence teValue : teValues) {
                if (!AsciiString.contentEqualsIgnoreCase((CharSequence)AsciiString.trim((CharSequence)teValue), (CharSequence)HttpHeaderValues.TRAILERS)) continue;
                out.add(HttpHeaderNames.TE, HttpHeaderValues.TRAILERS.toString());
                break;
            }
        }
    }

    private static URI toUri(HttpRequest in) throws URISyntaxException {
        String uri = in.uri();
        if (uri.startsWith("//")) {
            for (int i = 0; i < uri.length(); ++i) {
                if (uri.charAt(i) == '/') continue;
                return new URI(uri.substring(i - 1));
            }
            return ROOT;
        }
        return new URI(uri);
    }

    private static String toHttp2Path(URI uri) {
        StringBuilder pathBuilder = new StringBuilder(StringUtil.length((String)uri.getRawPath()) + StringUtil.length((String)uri.getRawQuery()) + StringUtil.length((String)uri.getRawFragment()) + 2);
        if (!StringUtil.isNullOrEmpty((String)uri.getRawPath())) {
            pathBuilder.append(uri.getRawPath());
        }
        if (!StringUtil.isNullOrEmpty((String)uri.getRawQuery())) {
            pathBuilder.append('?');
            pathBuilder.append(uri.getRawQuery());
        }
        if (!StringUtil.isNullOrEmpty((String)uri.getRawFragment())) {
            pathBuilder.append('#');
            pathBuilder.append(uri.getRawFragment());
        }
        return pathBuilder.length() != 0 ? pathBuilder.toString() : EMPTY_REQUEST_PATH;
    }

    static void setHttp2Authority(@Nullable String authority, HttpHeaders out) {
        if (authority != null) {
            String actualAuthority;
            if (authority.isEmpty()) {
                actualAuthority = "";
            } else {
                int start = authority.indexOf(64) + 1;
                if (start == 0) {
                    actualAuthority = authority;
                } else {
                    if (authority.length() == start) {
                        throw new IllegalArgumentException("authority: " + authority);
                    }
                    actualAuthority = authority.substring(start);
                }
            }
            out.authority(actualAuthority);
        }
    }

    private static void setHttp2Scheme(io.netty.handler.codec.http.HttpHeaders in, URI uri, HttpHeaders out) {
        String value = uri.getScheme();
        if (value != null) {
            out.scheme(value);
            return;
        }
        String cValue = in.get((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text());
        if (cValue != null) {
            out.scheme(cValue.toString());
        } else {
            out.scheme("unknown");
        }
    }

    public static Http2Headers toNettyHttp2(HttpHeaders in) {
        DefaultHttp2Headers out = new DefaultHttp2Headers(false, in.size());
        out.set((Headers)in);
        out.remove((Object)HttpHeaderNames.CONNECTION);
        out.remove((Object)HttpHeaderNames.TRANSFER_ENCODING);
        out.remove((Object)HttpHeaderNames.TRAILER);
        if (!out.contains((Object)HttpHeaderNames.COOKIE)) {
            return out;
        }
        List cookies = out.getAllAndRemove((Object)HttpHeaderNames.COOKIE);
        for (CharSequence c : cookies) {
            out.add((Object)HttpHeaderNames.COOKIE, COOKIE_SPLITTER.split(c));
        }
        return out;
    }

    public static void toNettyHttp1(int streamId, HttpHeaders inputHeaders, io.netty.handler.codec.http.HttpHeaders outputHeaders, HttpVersion httpVersion, boolean isTrailer, boolean isRequest) throws Http2Exception {
        CharSequenceMap translations = isRequest ? REQUEST_HEADER_TRANSLATIONS : RESPONSE_HEADER_TRANSLATIONS;
        StringJoiner cookieJoiner = null;
        try {
            Iterator<Map.Entry<AsciiString, String>> iterator = inputHeaders.iterator();
            while (iterator.hasNext()) {
                Map.Entry<AsciiString, String> entry = iterator.next();
                AsciiString name = entry.getKey();
                String value = entry.getValue();
                AsciiString translatedName = (AsciiString)translations.get(name);
                if (translatedName != null) {
                    outputHeaders.add((CharSequence)translatedName, (Object)value);
                    continue;
                }
                if (name.isEmpty() || HTTP2_TO_HTTP_HEADER_BLACKLIST.contains(name)) continue;
                if (HttpHeaderNames.COOKIE.equals((Object)name)) {
                    if (cookieJoiner == null) {
                        cookieJoiner = new StringJoiner(COOKIE_SEPARATOR);
                    }
                    COOKIE_SPLITTER.split(value).forEach(cookieJoiner::add);
                    continue;
                }
                outputHeaders.add((CharSequence)name, (Object)value);
            }
            if (cookieJoiner != null && cookieJoiner.length() != 0) {
                outputHeaders.add((CharSequence)HttpHeaderNames.COOKIE, (Object)cookieJoiner.toString());
            }
        }
        catch (Throwable t) {
            throw Http2Exception.streamError((int)streamId, (Http2Error)Http2Error.PROTOCOL_ERROR, (Throwable)t, (String)"HTTP/2 to HTTP/1.x headers conversion error", (Object[])new Object[0]);
        }
        if (!isTrailer) {
            HttpUtil.setKeepAlive((io.netty.handler.codec.http.HttpHeaders)outputHeaders, (HttpVersion)httpVersion, (boolean)true);
        }
    }

    private static String convertHeaderValue(AsciiString name, CharSequence value) {
        if (!(value instanceof AsciiString)) {
            return value.toString();
        }
        if (HEADER_VALUE_CACHE != null && CACHED_HEADERS.contains(name)) {
            String converted = HEADER_VALUE_CACHE.get((AsciiString)value);
            assert (converted != null);
            return converted;
        }
        return value.toString();
    }

    private ArmeriaHttpUtil() {
    }

    static {
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.CONNECTION, AsciiString.EMPTY_STRING);
        AsciiString keepAlive = HttpHeaderNames.KEEP_ALIVE;
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(keepAlive, AsciiString.EMPTY_STRING);
        AsciiString proxyConnection = HttpHeaderNames.PROXY_CONNECTION;
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(proxyConnection, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.TRANSFER_ENCODING, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.HOST, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.UPGRADE, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpConversionUtil.ExtensionHeaderNames.PATH.text(), AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_BLACKLIST.add(HttpHeaderNames.AUTHORITY, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_BLACKLIST.add(HttpHeaderNames.METHOD, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_BLACKLIST.add(HttpHeaderNames.PATH, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_BLACKLIST.add(HttpHeaderNames.SCHEME, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_BLACKLIST.add(HttpHeaderNames.STATUS, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_BLACKLIST.add(HttpHeaderNames.TRANSFER_ENCODING, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_BLACKLIST.add(HttpHeaderNames.TRAILER, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_BLACKLIST.add(HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_BLACKLIST.add(HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_BLACKLIST.add(HttpConversionUtil.ExtensionHeaderNames.PATH.text(), AsciiString.EMPTY_STRING);
        REQUEST_HEADER_TRANSLATIONS = new CharSequenceMap();
        RESPONSE_HEADER_TRANSLATIONS = new CharSequenceMap();
        RESPONSE_HEADER_TRANSLATIONS.add(Http2Headers.PseudoHeaderName.AUTHORITY.value(), HttpHeaderNames.HOST);
        REQUEST_HEADER_TRANSLATIONS.add((Headers)RESPONSE_HEADER_TRANSLATIONS);
        COOKIE_SPLITTER = Splitter.on(';').trimResults().omitEmptyStrings();
        HEADER_VALUE_CACHE = Flags.headerValueCacheSpec().map(ArmeriaHttpUtil::buildCache).orElse(null);
        CACHED_HEADERS = Flags.cachedHeaders().stream().map(AsciiString::of).collect(ImmutableSet.toImmutableSet());
    }

    private static final class CharSequenceMap
    extends DefaultHeaders<AsciiString, AsciiString, CharSequenceMap> {
        CharSequenceMap() {
            super(HTTP2_HEADER_NAME_HASHER, (ValueConverter)UnsupportedValueConverter.instance());
        }

        CharSequenceMap(int size) {
            super(HTTP2_HEADER_NAME_HASHER, (ValueConverter)UnsupportedValueConverter.instance(), DefaultHeaders.NameValidator.NOT_NULL, size);
        }
    }
}

