/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal;

import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;

public final class ChannelUtil {
    private static final Class<? extends EventLoopGroup> EPOLL_EVENT_LOOP_CLASS;

    public static Class<? extends EventLoopGroup> epollEventLoopClass() {
        return EPOLL_EVENT_LOOP_CLASS;
    }

    public static CompletableFuture<Void> close(Iterable<? extends Channel> channels) {
        ImmutableList<? extends Channel> channelsCopy = ImmutableList.copyOf(channels);
        if (channelsCopy.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        AtomicInteger numChannelsToClose = new AtomicInteger(channelsCopy.size());
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ChannelFutureListener listener = unused -> {
            if (numChannelsToClose.decrementAndGet() == 0) {
                future.complete(null);
            }
        };
        for (Channel channel : channelsCopy) {
            channel.close().addListener((GenericFutureListener)listener);
        }
        return future;
    }

    private ChannelUtil() {
    }

    static {
        try {
            EPOLL_EVENT_LOOP_CLASS = Class.forName("io.netty.channel.epoll.EpollEventLoop", false, EpollEventLoopGroup.class.getClassLoader());
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to locate EpollEventLoop class", e);
        }
    }
}

