/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public final class ConnectionLimitingHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionLimitingHandler.class);
    private final Set<Channel> childChannels = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Channel> unmodifiableChildChannels = Collections.unmodifiableSet(this.childChannels);
    private final int maxNumConnections;
    private final AtomicInteger numConnections = new AtomicInteger();
    private final AtomicBoolean loggingScheduled = new AtomicBoolean();
    private final LongAdder numDroppedConnections = new LongAdder();

    public ConnectionLimitingHandler(int maxNumConnections) {
        this.maxNumConnections = ConnectionLimitingHandler.validateMaxNumConnections(maxNumConnections);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel child = (Channel)msg;
        int conn = this.numConnections.incrementAndGet();
        if (conn > 0 && conn <= this.maxNumConnections) {
            this.childChannels.add(child);
            child.closeFuture().addListener(future -> {
                this.childChannels.remove(child);
                this.numConnections.decrementAndGet();
            });
            super.channelRead(ctx, msg);
        } else {
            this.numConnections.decrementAndGet();
            child.config().setOption(ChannelOption.SO_LINGER, (Object)0);
            child.unsafe().closeForcibly();
            this.numDroppedConnections.increment();
            if (this.loggingScheduled.compareAndSet(false, true)) {
                ctx.executor().schedule(this::writeNumDroppedConnectionsLog, 1L, TimeUnit.SECONDS);
            }
        }
    }

    private void writeNumDroppedConnectionsLog() {
        this.loggingScheduled.set(false);
        long dropped = this.numDroppedConnections.sumThenReset();
        if (dropped > 0L) {
            logger.warn("Dropped {} connection(s) to limit the number of open connections to {}", (Object)dropped, (Object)this.maxNumConnections);
        }
    }

    public int maxNumConnections() {
        return this.maxNumConnections;
    }

    public int numConnections() {
        return this.numConnections.get();
    }

    public Set<Channel> children() {
        return this.unmodifiableChildChannels;
    }

    public static int validateMaxNumConnections(int maxNumConnections) {
        if (maxNumConnections <= 0) {
            throw new IllegalArgumentException("maxNumConnections: " + maxNumConnections + " (expected: > 0)");
        }
        return maxNumConnections;
    }
}

