/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal;

import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.AttributeMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class DefaultAttributeMap
implements AttributeMap {
    private static final AtomicReferenceFieldUpdater<DefaultAttributeMap, AtomicReferenceArray> updater = AtomicReferenceFieldUpdater.newUpdater(DefaultAttributeMap.class, AtomicReferenceArray.class, "attributes");
    private static final int BUCKET_SIZE = 8;
    private static final int MASK = 7;
    volatile AtomicReferenceArray<DefaultAttribute<?>> attributes;

    public <T> Attribute<T> attr(AttributeKey<T> key) {
        int i;
        DefaultAttribute<Object> head;
        if (key == null) {
            throw new NullPointerException("key");
        }
        AtomicReferenceArray<DefaultAttribute<Object>> attributes = this.attributes;
        if (attributes == null && !updater.compareAndSet(this, null, attributes = new AtomicReferenceArray(8))) {
            attributes = this.attributes;
        }
        if ((head = attributes.get(i = DefaultAttributeMap.index(key))) == null) {
            head = new DefaultAttribute();
            DefaultAttribute<T> attr = new DefaultAttribute<T>(head, key);
            ((DefaultAttribute)head).next = (DefaultAttribute)attr;
            ((DefaultAttribute)attr).prev = (DefaultAttribute)head;
            if (attributes.compareAndSet(i, null, head)) {
                return attr;
            }
            head = attributes.get(i);
        }
        DefaultAttribute<?> defaultAttribute = head;
        synchronized (defaultAttribute) {
            DefaultAttribute curr = head;
            while (true) {
                DefaultAttribute next;
                if ((next = curr.next) == null) {
                    DefaultAttribute<T> attr = new DefaultAttribute<T>(head, key);
                    curr.next = (DefaultAttribute)attr;
                    ((DefaultAttribute)attr).prev = curr;
                    return attr;
                }
                if (next.key == key && !next.removed) {
                    return next;
                }
                curr = next;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean hasAttr(AttributeKey<T> key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        AtomicReferenceArray<DefaultAttribute<?>> attributes = this.attributes;
        if (attributes == null) {
            return false;
        }
        int i = DefaultAttributeMap.index(key);
        DefaultAttribute<?> head = attributes.get(i);
        if (head == null) {
            return false;
        }
        DefaultAttribute<?> defaultAttribute = head;
        synchronized (defaultAttribute) {
            DefaultAttribute curr = ((DefaultAttribute)head).next;
            while (curr != null) {
                if (curr.key == key && !curr.removed) {
                    return true;
                }
                curr = curr.next;
            }
            return false;
        }
    }

    public Iterator<Attribute<?>> attrs() {
        AtomicReferenceArray<DefaultAttribute<?>> attributes = this.attributes;
        if (attributes == null) {
            return Collections.emptyIterator();
        }
        return new IteratorImpl(attributes);
    }

    private static int index(AttributeKey<?> key) {
        return key.id() & 7;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("");
        Iterator<Attribute<?>> i = this.attrs();
        while (i.hasNext()) {
            Attribute<?> a = i.next();
            helper.add(a.key().name(), a.get());
        }
        return helper.toString();
    }

    private static final class IteratorImpl
    implements Iterator<Attribute<?>> {
        private final AtomicReferenceArray<DefaultAttribute<?>> attributes;
        private int idx = -1;
        private DefaultAttribute<?> next;

        IteratorImpl(AtomicReferenceArray<DefaultAttribute<?>> attributes) {
            this.attributes = attributes;
            this.next = this.findNext(null);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Attribute<?> next() {
            DefaultAttribute<?> next = this.next;
            if (next == null) {
                throw new NoSuchElementException();
            }
            this.next = this.findNext(((DefaultAttribute)next).next);
            return next;
        }

        private DefaultAttribute<?> findNext(DefaultAttribute<?> next) {
            block0: while (true) {
                if (next == null) {
                    ++this.idx;
                    while (this.idx < this.attributes.length()) {
                        DefaultAttribute<?> head = this.attributes.get(this.idx);
                        if (head != null && ((DefaultAttribute)head).next != null) {
                            next = ((DefaultAttribute)head).next;
                            break;
                        }
                        ++this.idx;
                    }
                    if (next == null) {
                        return null;
                    }
                }
                while (next.removed) {
                    if ((next = next.next) != null) continue;
                    continue block0;
                }
                break;
            }
            return next;
        }
    }

    private static final class DefaultAttribute<T>
    extends AtomicReference<T>
    implements Attribute<T> {
        private static final long serialVersionUID = -2661411462200283011L;
        private final DefaultAttribute<?> head;
        private final AttributeKey<T> key;
        private DefaultAttribute<?> prev;
        private DefaultAttribute<?> next;
        private volatile boolean removed;

        DefaultAttribute(DefaultAttribute<?> head, AttributeKey<T> key) {
            this.head = head;
            this.key = key;
        }

        DefaultAttribute() {
            this.head = this;
            this.key = null;
        }

        public AttributeKey<T> key() {
            return this.key;
        }

        public T setIfAbsent(T value) {
            while (!this.compareAndSet(null, value)) {
                Object old = this.get();
                if (old == null) continue;
                return (T)old;
            }
            return null;
        }

        public T getAndRemove() {
            this.removed = true;
            T oldValue = this.getAndSet(null);
            this.remove0();
            return oldValue;
        }

        public void remove() {
            this.removed = true;
            this.set(null);
            this.remove0();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove0() {
            DefaultAttribute<?> defaultAttribute = this.head;
            synchronized (defaultAttribute) {
                if (this.prev == null) {
                    return;
                }
                this.prev.next = this.next;
                if (this.next != null) {
                    this.next.prev = this.prev;
                }
                this.prev = null;
                this.next = null;
            }
        }
    }
}

