/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal;

import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.HttpStatusClass;
import com.linecorp.armeria.common.stream.ClosedPublisherException;
import com.linecorp.armeria.internal.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.HttpObjectEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;

public final class Http1ObjectEncoder
extends HttpObjectEncoder {
    private static final int MAX_TLS_DATA_LENGTH = 16378;
    private static final HttpContent EMPTY_CONTENT = new DefaultHttpContent(Unpooled.EMPTY_BUFFER);
    private final Channel ch;
    private final boolean server;
    private final boolean isTls;
    private int currentId = 1;
    private int minClosedId = Integer.MAX_VALUE;
    private int maxIdWithPendingWrites = Integer.MIN_VALUE;
    private final IntObjectMap<PendingWrites> pendingWritesMap = new IntObjectHashMap();

    public Http1ObjectEncoder(Channel ch, boolean server, boolean isTls) {
        this.ch = Objects.requireNonNull(ch, "ch");
        this.server = server;
        this.isTls = isTls;
    }

    @Override
    protected Channel channel() {
        return this.ch;
    }

    @Override
    protected ChannelFuture doWriteHeaders(int id, int streamId, HttpHeaders headers, boolean endStream) {
        if (id >= this.minClosedId) {
            return this.newClosedSessionFuture();
        }
        try {
            return this.server ? this.writeServerHeaders(id, streamId, headers, endStream) : this.writeClientHeaders(id, streamId, headers, endStream);
        }
        catch (Throwable t) {
            return this.newFailedFuture(t);
        }
    }

    private ChannelFuture writeServerHeaders(int id, int streamId, HttpHeaders headers, boolean endStream) throws Http2Exception {
        HttpObject converted = this.convertServerHeaders(streamId, headers, endStream);
        HttpStatus status = headers.status();
        if (status == null) {
            ChannelFuture f = this.write(id, converted, endStream);
            this.ch.flush();
            return f;
        }
        if (status.codeClass() == HttpStatusClass.INFORMATIONAL) {
            ChannelFuture f = this.write(id, converted, false);
            if (endStream) {
                f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
            this.ch.flush();
            return f;
        }
        return this.writeNonInformationalHeaders(id, converted, endStream);
    }

    private ChannelFuture writeClientHeaders(int id, int streamId, HttpHeaders headers, boolean endStream) throws Http2Exception {
        return this.writeNonInformationalHeaders(id, this.convertClientHeaders(streamId, headers, endStream), endStream);
    }

    private ChannelFuture writeNonInformationalHeaders(int id, HttpObject converted, boolean endStream) {
        ChannelFuture f;
        if (converted instanceof LastHttpContent) {
            assert (endStream);
            f = this.write(id, converted, true);
        } else {
            f = this.write(id, converted, false);
            if (endStream) {
                f = this.write(id, (HttpObject)LastHttpContent.EMPTY_LAST_CONTENT, true);
            }
        }
        this.ch.flush();
        return f;
    }

    private HttpObject convertServerHeaders(int streamId, HttpHeaders headers, boolean endStream) throws Http2Exception {
        DefaultFullHttpResponse res;
        HttpStatus status = headers.status();
        if (status == null) {
            return this.convertTrailingHeaders(streamId, headers);
        }
        boolean informational = status.codeClass() == HttpStatusClass.INFORMATIONAL;
        HttpResponseStatus nettyStatus = HttpResponseStatus.valueOf((int)status.code());
        if (endStream || informational) {
            res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, nettyStatus, Unpooled.EMPTY_BUFFER, false);
            io.netty.handler.codec.http.HttpHeaders outHeaders = res.headers();
            this.convert(streamId, headers, outHeaders, false);
            if (informational) {
                outHeaders.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            } else if (!headers.contains(HttpHeaderNames.CONTENT_LENGTH)) {
                outHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0);
            }
        } else {
            res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, nettyStatus, false);
            this.convert(streamId, headers, res.headers(), false);
            Http1ObjectEncoder.setTransferEncoding((HttpMessage)res);
        }
        return res;
    }

    private HttpObject convertClientHeaders(int streamId, HttpHeaders headers, boolean endStream) throws Http2Exception {
        com.linecorp.armeria.common.HttpMethod method = headers.method();
        if (method == null) {
            return this.convertTrailingHeaders(streamId, headers);
        }
        String path = headers.path();
        assert (path != null);
        DefaultHttpRequest req = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)method.name()), path, false);
        this.convert(streamId, headers, req.headers(), false);
        if (endStream) {
            req.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            req.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        } else if (HttpUtil.getContentLength((HttpMessage)req, (long)-1L) >= 0L) {
            req.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        } else {
            req.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        }
        return req;
    }

    private void convert(int streamId, HttpHeaders inHeaders, io.netty.handler.codec.http.HttpHeaders outHeaders, boolean trailer) throws Http2Exception {
        ArmeriaHttpUtil.toNettyHttp1(streamId, inHeaders, outHeaders, HttpVersion.HTTP_1_1, trailer, false);
        outHeaders.remove((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
        if (this.server) {
            outHeaders.remove((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text());
        } else {
            outHeaders.remove((CharSequence)HttpConversionUtil.ExtensionHeaderNames.PATH.text());
        }
    }

    private LastHttpContent convertTrailingHeaders(int streamId, HttpHeaders headers) throws Http2Exception {
        LastHttpContent lastContent;
        if (headers.isEmpty()) {
            lastContent = LastHttpContent.EMPTY_LAST_CONTENT;
        } else {
            lastContent = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, false);
            this.convert(streamId, headers, lastContent.trailingHeaders(), true);
        }
        return lastContent;
    }

    private static void setTransferEncoding(HttpMessage out) {
        io.netty.handler.codec.http.HttpHeaders outHeaders = out.headers();
        long contentLength = HttpUtil.getContentLength((HttpMessage)out, (long)-1L);
        if (contentLength < 0L) {
            outHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            outHeaders.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        }
    }

    @Override
    protected ChannelFuture doWriteData(int id, int streamId, HttpData data, boolean endStream) {
        if (id >= this.minClosedId) {
            ReferenceCountUtil.safeRelease((Object)data);
            return this.newClosedSessionFuture();
        }
        int length = data.length();
        if (length == 0) {
            ReferenceCountUtil.safeRelease((Object)data);
            LastHttpContent content = endStream ? LastHttpContent.EMPTY_LAST_CONTENT : EMPTY_CONTENT;
            ChannelFuture future = this.write(id, (HttpObject)content, endStream);
            this.ch.flush();
            return future;
        }
        try {
            if (!this.isTls || length <= 16378) {
                return this.doWriteUnsplitData(id, data, endStream);
            }
            return this.doWriteSplitData(id, data, endStream);
        }
        catch (Throwable t) {
            return this.newFailedFuture(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture doWriteUnsplitData(int id, HttpData data, boolean endStream) {
        ByteBuf buf = this.toByteBuf(data);
        boolean handled = false;
        try {
            Object content = endStream ? new DefaultLastHttpContent(buf) : new DefaultHttpContent(buf);
            ChannelFuture future = this.write(id, (HttpObject)content, endStream);
            handled = true;
            this.ch.flush();
            ChannelFuture channelFuture = future;
            return channelFuture;
        }
        finally {
            if (!handled) {
                ReferenceCountUtil.safeRelease((Object)buf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture doWriteSplitData(int id, HttpData data, boolean endStream) {
        try {
            ChannelFuture lastFuture;
            int offset = data.offset();
            int remaining = data.length();
            while (true) {
                int chunkSize = Math.min(16378, remaining);
                lastFuture = this.write(id, (HttpObject)new DefaultHttpContent(Http1ObjectEncoder.dataChunk(data, offset, chunkSize)), false);
                if ((remaining -= chunkSize) == 0) break;
                offset += chunkSize;
            }
            if (endStream) {
                lastFuture = this.write(id, (HttpObject)LastHttpContent.EMPTY_LAST_CONTENT, true);
            }
            this.ch.flush();
            ChannelFuture channelFuture = lastFuture;
            return channelFuture;
        }
        finally {
            ReferenceCountUtil.safeRelease((Object)data);
        }
    }

    private static ByteBuf dataChunk(HttpData data, int offset, int chunkSize) {
        if (data instanceof ByteBufHolder) {
            ByteBuf buf = ((ByteBufHolder)data).content();
            return buf.retainedSlice(offset, chunkSize);
        }
        return Unpooled.wrappedBuffer((byte[])data.array(), (int)offset, (int)chunkSize);
    }

    private ChannelFuture write(int id, HttpObject obj, boolean endStream) {
        PendingWrites pendingWrites;
        if (id < this.currentId) {
            ReferenceCountUtil.safeRelease((Object)obj);
            return this.newFailedFuture(ClosedPublisherException.get());
        }
        PendingWrites currentPendingWrites = (PendingWrites)this.pendingWritesMap.get(id);
        if (id == this.currentId) {
            if (currentPendingWrites != null) {
                this.pendingWritesMap.remove(id);
                this.flushPendingWrites(currentPendingWrites);
            }
            ChannelFuture future = this.ch.write((Object)obj);
            if (endStream) {
                PendingWrites nextPendingWrites;
                ++this.currentId;
                while ((nextPendingWrites = (PendingWrites)this.pendingWritesMap.get(this.currentId)) != null) {
                    this.flushPendingWrites(nextPendingWrites);
                    if (!nextPendingWrites.isEndOfStream()) break;
                    this.pendingWritesMap.remove(this.currentId);
                    ++this.currentId;
                }
            }
            return future;
        }
        ChannelPromise promise = this.ch.newPromise();
        AbstractMap.SimpleImmutableEntry<HttpObject, ChannelPromise> entry = new AbstractMap.SimpleImmutableEntry<HttpObject, ChannelPromise>(obj, promise);
        if (currentPendingWrites == null) {
            pendingWrites = new PendingWrites();
            this.maxIdWithPendingWrites = Math.max(this.maxIdWithPendingWrites, id);
            this.pendingWritesMap.put(id, (Object)pendingWrites);
        } else {
            pendingWrites = currentPendingWrites;
        }
        pendingWrites.add((Map.Entry<HttpObject, ChannelPromise>)entry);
        if (endStream) {
            pendingWrites.setEndOfStream();
        }
        return promise;
    }

    private void flushPendingWrites(PendingWrites pendingWrites) {
        Map.Entry e;
        while ((e = (Map.Entry)pendingWrites.poll()) != null) {
            this.ch.write(e.getKey(), (ChannelPromise)e.getValue());
        }
    }

    @Override
    protected ChannelFuture doWriteReset(int id, int streamId, Http2Error error) {
        for (int i = this.minClosedId = Math.min(this.minClosedId, id); i <= this.maxIdWithPendingWrites; ++i) {
            Map.Entry e;
            PendingWrites pendingWrites = (PendingWrites)this.pendingWritesMap.remove(i);
            while ((e = (Map.Entry)pendingWrites.poll()) != null) {
                ((ChannelPromise)e.getValue()).tryFailure((Throwable)ClosedSessionException.get());
            }
        }
        ChannelFuture f = this.ch.write((Object)Unpooled.EMPTY_BUFFER);
        if (this.currentId >= this.minClosedId) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        return f;
    }

    @Override
    protected void doClose() {
        if (this.pendingWritesMap.isEmpty()) {
            return;
        }
        ClosedSessionException cause = ClosedSessionException.get();
        for (Queue queue : this.pendingWritesMap.values()) {
            Map.Entry e;
            while ((e = (Map.Entry)queue.poll()) != null) {
                ((ChannelPromise)e.getValue()).tryFailure((Throwable)cause);
            }
        }
        this.pendingWritesMap.clear();
    }

    private static final class PendingWrites
    extends ArrayDeque<Map.Entry<HttpObject, ChannelPromise>> {
        private static final long serialVersionUID = 4241891747461017445L;
        private boolean endOfStream;

        PendingWrites() {
            super(4);
        }

        @Override
        public boolean add(Map.Entry<HttpObject, ChannelPromise> httpObjectChannelPromiseEntry) {
            return this.isEndOfStream() ? false : super.add(httpObjectChannelPromiseEntry);
        }

        boolean isEndOfStream() {
            return this.endOfStream;
        }

        void setEndOfStream() {
            this.endOfStream = true;
        }
    }
}

