/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Stream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Http2GoAwayHandler {
    private static final Logger logger = LoggerFactory.getLogger(Http2GoAwayHandler.class);
    private boolean goAwaySent;
    private long goAwayReceived;

    public boolean receivedGoAway() {
        return this.goAwayReceived >= 0L;
    }

    public boolean receivedErrorGoAway() {
        return this.goAwayReceived > Http2Error.NO_ERROR.code();
    }

    public void onGoAwaySent(Channel channel, int lastStreamId, long errorCode, ByteBuf debugData) {
        this.goAwaySent = true;
        Http2GoAwayHandler.onGoAway(channel, "Sent", lastStreamId, errorCode, debugData);
    }

    public void onGoAwayReceived(Channel channel, int lastStreamId, long errorCode, ByteBuf debugData) {
        this.goAwayReceived = errorCode;
        Http2GoAwayHandler.onGoAway(channel, "Received", lastStreamId, errorCode, debugData);
        if (!this.goAwaySent) {
            channel.close();
        }
    }

    private static void onGoAway(Channel channel, String sentOrReceived, int lastStreamId, long errorCode, ByteBuf debugData) {
        if (errorCode != Http2Error.NO_ERROR.code()) {
            if (logger.isWarnEnabled()) {
                logger.warn("{} {} a GOAWAY frame: lastStreamId={}, errorCode={}, debugData=\"{}\"", new Object[]{channel, sentOrReceived, lastStreamId, Http2GoAwayHandler.errorStr(errorCode), debugData.toString(StandardCharsets.UTF_8)});
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("{} {} a GOAWAY frame: lastStreamId={}, errorCode=NO_ERROR(0)", new Object[]{channel, sentOrReceived, lastStreamId});
        }
    }

    private static String errorStr(long errorCode) {
        Http2Error error = Http2Error.valueOf((long)errorCode);
        return error != null ? error.toString() + '(' + errorCode + ')' : "UNKNOWN(" + errorCode + ')';
    }

    public void onStreamClosed(Channel channel, Http2Stream stream) {
        if (stream.id() == 1) {
            logger.debug("{} HTTP/2 upgrade stream closed: {}", (Object)channel, (Object)stream.state());
        }
    }
}

