/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.stream.ClosedPublisherException;
import com.linecorp.armeria.internal.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.HttpObjectEncoder;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.ReferenceCountUtil;
import java.util.Objects;

public final class Http2ObjectEncoder
extends HttpObjectEncoder {
    private final ChannelHandlerContext ctx;
    private final Http2ConnectionEncoder encoder;

    public Http2ObjectEncoder(ChannelHandlerContext ctx, Http2ConnectionEncoder encoder) {
        this.ctx = Objects.requireNonNull(ctx, "ctx");
        this.encoder = Objects.requireNonNull(encoder, "encoder");
    }

    @Override
    protected Channel channel() {
        return this.ctx.channel();
    }

    @Override
    protected ChannelFuture doWriteHeaders(int id, int streamId, HttpHeaders headers, boolean endStream) {
        if (this.isStreamPresentAndWritable(streamId)) {
            return this.encoder.writeHeaders(this.ctx, streamId, ArmeriaHttpUtil.toNettyHttp2(headers), 0, endStream, this.ctx.newPromise());
        }
        Http2Connection conn = this.encoder.connection();
        if (conn.isServer()) {
            return this.newFailedFuture(ClosedPublisherException.get());
        }
        if (conn.local().mayHaveCreatedStream(streamId)) {
            return this.newFailedFuture(ClosedPublisherException.get());
        }
        return this.encoder.writeHeaders(this.ctx, streamId, ArmeriaHttpUtil.toNettyHttp2(headers), 0, endStream, this.ctx.newPromise());
    }

    @Override
    protected ChannelFuture doWriteData(int id, int streamId, HttpData data, boolean endStream) {
        if (this.isStreamPresentAndWritable(streamId)) {
            return this.encoder.writeData(this.ctx, streamId, this.toByteBuf(data), 0, endStream, this.ctx.newPromise());
        }
        if (this.encoder.connection().local().mayHaveCreatedStream(streamId)) {
            ReferenceCountUtil.safeRelease((Object)data);
            return data.isEmpty() ? this.ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER) : this.newFailedFuture(ClosedPublisherException.get());
        }
        ReferenceCountUtil.safeRelease((Object)data);
        return this.newFailedFuture(new IllegalStateException("cannot start a new stream " + streamId + " with a DATA frame"));
    }

    @Override
    protected ChannelFuture doWriteReset(int id, int streamId, Http2Error error) {
        Http2Stream stream = this.encoder.connection().stream(streamId);
        if (stream != null && !stream.isResetSent()) {
            return this.encoder.writeRstStream(this.ctx, streamId, error.code(), this.ctx.newPromise());
        }
        return this.ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER);
    }

    private boolean isStreamPresentAndWritable(int streamId) {
        Http2Stream stream = this.encoder.connection().stream(streamId);
        if (stream == null) {
            return false;
        }
        switch (stream.state()) {
            case RESERVED_LOCAL: 
            case OPEN: 
            case HALF_CLOSED_REMOTE: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void doClose() {
    }
}

