/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.HttpStatusClass;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class HttpHeaderSubscriber
implements BiConsumer<Void, Throwable>,
Subscriber<HttpObject> {
    private final CompletableFuture<HttpHeaders> future;
    @Nullable
    private Subscription subscription;
    @Nullable
    private HttpHeaders headers;

    public HttpHeaderSubscriber(CompletableFuture<HttpHeaders> future) {
        this.future = future;
    }

    public void onSubscribe(Subscription s) {
        this.subscription = s;
        s.request(Long.MAX_VALUE);
    }

    public void onNext(HttpObject o) {
        HttpHeaders headers;
        HttpStatus status;
        if (o instanceof HttpHeaders && (status = (headers = (HttpHeaders)o).status()) != null && status.codeClass() != HttpStatusClass.INFORMATIONAL && this.headers == null) {
            this.headers = headers;
            assert (this.subscription != null);
            this.subscription.cancel();
        }
    }

    public void onError(Throwable t) {
    }

    public void onComplete() {
    }

    @Override
    public void accept(Void aVoid, Throwable thrown) {
        if (thrown != null && !(thrown instanceof CancelledSubscriptionException) && !(thrown instanceof AbortedStreamException)) {
            this.future.completeExceptionally(thrown);
        } else {
            this.future.complete(MoreObjects.firstNonNull(this.headers, HttpHeaders.EMPTY_HEADERS));
        }
    }
}

