/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal;

import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.util.ReferenceCountUtil;

public abstract class HttpObjectEncoder {
    private volatile boolean closed;

    protected abstract Channel channel();

    protected EventLoop eventLoop() {
        return this.channel().eventLoop();
    }

    public final ChannelFuture writeHeaders(int id, int streamId, HttpHeaders headers, boolean endStream) {
        assert (this.eventLoop().inEventLoop());
        if (this.closed) {
            return this.newClosedSessionFuture();
        }
        return this.doWriteHeaders(id, streamId, headers, endStream);
    }

    protected abstract ChannelFuture doWriteHeaders(int var1, int var2, HttpHeaders var3, boolean var4);

    public final ChannelFuture writeData(int id, int streamId, HttpData data, boolean endStream) {
        assert (this.eventLoop().inEventLoop());
        if (this.closed) {
            ReferenceCountUtil.safeRelease((Object)data);
            return this.newClosedSessionFuture();
        }
        return this.doWriteData(id, streamId, data, endStream);
    }

    protected abstract ChannelFuture doWriteData(int var1, int var2, HttpData var3, boolean var4);

    public final ChannelFuture writeReset(int id, int streamId, Http2Error error) {
        if (this.closed) {
            return this.newClosedSessionFuture();
        }
        return this.doWriteReset(id, streamId, error);
    }

    protected abstract ChannelFuture doWriteReset(int var1, int var2, Http2Error var3);

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.doClose();
    }

    protected abstract void doClose();

    protected final ChannelFuture newClosedSessionFuture() {
        return this.newFailedFuture(ClosedSessionException.get());
    }

    protected final ChannelFuture newFailedFuture(Throwable cause) {
        return this.channel().newFailedFuture(cause);
    }

    protected final ByteBuf toByteBuf(HttpData data) {
        if (data instanceof ByteBufHolder) {
            return ((ByteBufHolder)data).content();
        }
        ByteBuf buf = this.channel().alloc().directBuffer(data.length(), data.length());
        buf.writeBytes(data.array(), data.offset(), data.length());
        return buf;
    }
}

