/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IdleTimeoutHandler
extends IdleStateHandler {
    private static final Logger logger = LoggerFactory.getLogger(IdleTimeoutHandler.class);
    private final String name;

    protected IdleTimeoutHandler(String name, long idleTimeoutMillis) {
        super(0L, 0L, idleTimeoutMillis, TimeUnit.MILLISECONDS);
        this.name = Objects.requireNonNull(name, "name");
    }

    protected final void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
        if (!evt.isFirst()) {
            return;
        }
        if (!this.hasRequestsInProgress(ctx)) {
            logger.debug("{} Closing an idle {} connection", (Object)ctx.channel(), (Object)this.name);
            ctx.channel().close();
        }
    }

    protected abstract boolean hasRequestsInProgress(ChannelHandlerContext var1);
}

