/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal;

import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public final class InboundTrafficController
extends AtomicInteger {
    private static final long serialVersionUID = 420503276551000218L;
    private static int numDeferredReads;
    @Nullable
    private final ChannelConfig cfg;
    private final int highWatermark;
    private final int lowWatermark;
    private volatile boolean suspended;

    public static int numDeferredReads() {
        return numDeferredReads;
    }

    public InboundTrafficController(@Nullable Channel channel) {
        this(channel, 131072, 65536);
    }

    public InboundTrafficController(@Nullable Channel channel, int highWatermark, int lowWatermark) {
        this.cfg = channel != null ? channel.config() : null;
        this.highWatermark = highWatermark;
        this.lowWatermark = lowWatermark;
    }

    public void inc(int numProducedBytes) {
        int oldValue = this.getAndAdd(numProducedBytes);
        if (oldValue <= this.highWatermark && oldValue + numProducedBytes > this.highWatermark && this.cfg != null) {
            this.cfg.setAutoRead(false);
            ++numDeferredReads;
            this.suspended = true;
        }
    }

    public void dec(int numConsumedBytes) {
        int oldValue = this.getAndAdd(-numConsumedBytes);
        if (oldValue > this.lowWatermark && oldValue - numConsumedBytes <= this.lowWatermark && this.cfg != null) {
            this.cfg.setAutoRead(true);
            this.suspended = false;
        }
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("suspended", this.suspended).add("unconsumed", this.get()).add("watermarks", this.highWatermark + "/" + this.lowWatermark).toString();
    }
}

