/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.internal.metric.CaffeineMetricSupport;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Cache;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Caffeine;
import com.linecorp.armeria.internal.shaded.fastutil.bytes.ByteArrays;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.util.internal.StringUtil;
import java.util.BitSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class PathAndQuery {
    private static final PathAndQuery ROOT_PATH_QUERY = new PathAndQuery("/", null);
    private static final BitSet ALLOWED_PATH_CHARS = new BitSet();
    private static final BitSet ALLOWED_QUERY_CHARS = new BitSet();
    private static final Bytes EMPTY_QUERY;
    private static final Bytes ROOT_PATH;
    private static final int ENCODED_AMPERSAND = 253;
    private static final int ENCODED_SEMICOLON = 254;
    private static final int ENCODED_EQUAL = 255;
    @Nullable
    private static final Cache<String, PathAndQuery> CACHE;
    private final String path;
    @Nullable
    private final String query;

    private static Cache<String, PathAndQuery> buildCache(String spec) {
        return Caffeine.from(spec).build();
    }

    public static void registerMetrics(MeterRegistry registry, MeterIdPrefix idPrefix) {
        if (CACHE != null) {
            CaffeineMetricSupport.setup(registry, idPrefix, CACHE);
        }
    }

    public static void clearCachedPaths() {
        Objects.requireNonNull(CACHE, "CACHE");
        CACHE.asMap().clear();
    }

    public static Set<String> cachedPaths() {
        Objects.requireNonNull(CACHE, "CACHE");
        return CACHE.asMap().keySet();
    }

    @Nullable
    public static PathAndQuery parse(@Nullable String rawPath) {
        PathAndQuery parsed;
        if (CACHE != null && rawPath != null && (parsed = CACHE.getIfPresent(rawPath)) != null) {
            return parsed;
        }
        return PathAndQuery.splitPathAndQuery(rawPath);
    }

    public void storeInCache(@Nullable String rawPath) {
        if (CACHE != null && rawPath != null) {
            CACHE.put(rawPath, this);
        }
    }

    private PathAndQuery(String path, @Nullable String query) {
        this.path = path;
        this.query = query;
    }

    public String path() {
        return this.path;
    }

    @Nullable
    public String query() {
        return this.query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathAndQuery)) {
            return false;
        }
        PathAndQuery that = (PathAndQuery)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.query, that.query);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.query);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("path", this.path).add("query", this.query).toString();
    }

    @Nullable
    private static PathAndQuery splitPathAndQuery(@Nullable String pathAndQuery) {
        Bytes query;
        Bytes path;
        if (pathAndQuery == null) {
            return ROOT_PATH_QUERY;
        }
        int queryPos = pathAndQuery.indexOf(63);
        if (queryPos >= 0) {
            path = PathAndQuery.decodePercentsAndEncodeToUtf8(pathAndQuery, 0, queryPos, true);
            if (path == null) {
                return null;
            }
            query = PathAndQuery.decodePercentsAndEncodeToUtf8(pathAndQuery, queryPos + 1, pathAndQuery.length(), false);
            if (query == null) {
                return null;
            }
        } else {
            path = PathAndQuery.decodePercentsAndEncodeToUtf8(pathAndQuery, 0, pathAndQuery.length(), true);
            if (path == null) {
                return null;
            }
            query = null;
        }
        if (path.data[0] != 47) {
            return null;
        }
        if (PathAndQuery.firstPathComponentContainsColon(path) || PathAndQuery.pathContainsDoubleDots(path)) {
            return null;
        }
        return new PathAndQuery(PathAndQuery.encodeToPercents(path, true), query != null ? PathAndQuery.encodeToPercents(query, false) : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static Bytes decodePercentsAndEncodeToUtf8(String value, int start, int end, boolean isPath) {
        int length = end - start;
        if (length == 0) {
            return isPath ? ROOT_PATH : EMPTY_QUERY;
        }
        Bytes buf = new Bytes(Math.max(length * 3 / 2, 4));
        boolean wasSlash = false;
        CodePointIterator i = new CodePointIterator(value, start, end);
        while (i.hasNextCodePoint()) {
            int pos = i.position();
            int cp = i.nextCodePoint();
            if (cp == 37) {
                int hexEnd = pos + 3;
                if (hexEnd > end) {
                    return null;
                }
                int digit1 = StringUtil.decodeHexNibble((char)value.charAt(pos + 1));
                int digit2 = StringUtil.decodeHexNibble((char)value.charAt(pos + 2));
                if (digit1 < 0 || digit2 < 0) {
                    return null;
                }
                int decoded = digit1 << 4 | digit2;
                if (isPath) {
                    if (!PathAndQuery.appendOneByte(buf, decoded, wasSlash, isPath)) return null;
                    wasSlash = decoded == 47;
                } else if (decoded == 38) {
                    buf.ensure(1);
                    buf.add((byte)-3);
                    wasSlash = false;
                } else if (decoded == 59) {
                    buf.ensure(1);
                    buf.add((byte)-2);
                    wasSlash = false;
                } else if (decoded == 61) {
                    buf.ensure(1);
                    buf.add((byte)-1);
                    wasSlash = false;
                } else {
                    if (!PathAndQuery.appendOneByte(buf, decoded, wasSlash, isPath)) return null;
                    wasSlash = decoded == 47;
                }
                i.position(hexEnd);
                continue;
            }
            if (cp == 43 && !isPath) {
                buf.ensure(1);
                buf.add((byte)32);
                wasSlash = false;
                continue;
            }
            if (cp <= 127) {
                if (!PathAndQuery.appendOneByte(buf, cp, wasSlash, isPath)) {
                    return null;
                }
                wasSlash = cp == 47;
                continue;
            }
            if (cp <= 2047) {
                buf.ensure(2);
                buf.add((byte)(cp >>> 6 | 0xC0));
                buf.add((byte)(cp & 0x3F | 0x80));
            } else if (cp <= 65535) {
                buf.ensure(3);
                buf.add((byte)(cp >>> 12 | 0xE0));
                buf.add((byte)(cp >>> 6 & 0x3F | 0x80));
                buf.add((byte)(cp & 0x3F | 0x80));
            } else if (cp <= 0x1FFFFF) {
                buf.ensure(4);
                buf.add((byte)(cp >>> 18 | 0xF0));
                buf.add((byte)(cp >>> 12 & 0x3F | 0x80));
                buf.add((byte)(cp >>> 6 & 0x3F | 0x80));
                buf.add((byte)(cp & 0x3F | 0x80));
            } else if (cp <= 0x3FFFFFF) {
                buf.ensure(5);
                buf.add((byte)(cp >>> 24 | 0xF8));
                buf.add((byte)(cp >>> 18 & 0x3F | 0x80));
                buf.add((byte)(cp >>> 12 & 0x3F | 0x80));
                buf.add((byte)(cp >>> 6 & 0x3F | 0x80));
                buf.add((byte)(cp & 0x3F | 0x80));
            } else {
                buf.ensure(6);
                buf.add((byte)(cp >>> 30 | 0xFC));
                buf.add((byte)(cp >>> 24 & 0x3F | 0x80));
                buf.add((byte)(cp >>> 18 & 0x3F | 0x80));
                buf.add((byte)(cp >>> 12 & 0x3F | 0x80));
                buf.add((byte)(cp >>> 6 & 0x3F | 0x80));
                buf.add((byte)(cp & 0x3F | 0x80));
            }
            wasSlash = false;
        }
        return buf;
    }

    private static boolean appendOneByte(Bytes buf, int cp, boolean wasSlash, boolean isPath) {
        if (cp == 127) {
            return false;
        }
        if (cp >>> 5 == 0) {
            if (isPath) {
                return false;
            }
            if (cp != 10 && cp != 13 && cp != 9) {
                return false;
            }
        }
        if (cp == 47 && isPath) {
            if (!wasSlash) {
                buf.ensure(1);
                buf.add((byte)47);
            }
        } else {
            buf.ensure(1);
            buf.add((byte)cp);
        }
        return true;
    }

    private static boolean firstPathComponentContainsColon(Bytes path) {
        byte b;
        int length = path.length;
        for (int i = 1; i < length && (b = path.data[i]) != 47; ++i) {
            if (b != 58) continue;
            return true;
        }
        return false;
    }

    private static boolean pathContainsDoubleDots(Bytes path) {
        int length = path.length;
        int b0 = 0;
        int b1 = 0;
        int b2 = 47;
        for (int i = 1; i < length; ++i) {
            int b3 = path.data[i];
            if (b3 == 47 && b2 == 46 && b1 == 46 && b0 == 47) {
                return true;
            }
            b0 = b1;
            b1 = b2;
            b2 = b3;
        }
        return b0 == 47 && b1 == 46 && b2 == 46;
    }

    private static String encodeToPercents(Bytes value, boolean isPath) {
        BitSet allowedChars = isPath ? ALLOWED_PATH_CHARS : ALLOWED_QUERY_CHARS;
        int length = value.length;
        boolean needsEncoding = false;
        for (int i = 0; i < length; ++i) {
            if (allowedChars.get(value.data[i] & 0xFF)) continue;
            needsEncoding = true;
            break;
        }
        if (!needsEncoding) {
            return new String(value.data, 0, 0, length);
        }
        StringBuilder buf = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int b = value.data[i] & 0xFF;
            if (allowedChars.get(b)) {
                buf.append((char)b);
                continue;
            }
            if (b == 43 && !isPath) {
                buf.append("%2B");
                continue;
            }
            if (b == 32) {
                if (isPath) {
                    buf.append("%20");
                    continue;
                }
                buf.append('+');
                continue;
            }
            if (b == 253) {
                buf.append("%26");
                continue;
            }
            if (b == 254) {
                buf.append("%3B");
                continue;
            }
            if (b == 255) {
                buf.append("%3D");
                continue;
            }
            buf.append('%');
            PathAndQuery.appendHexNibble(buf, b >>> 4);
            PathAndQuery.appendHexNibble(buf, b & 0xF);
        }
        return buf.toString();
    }

    private static void appendHexNibble(StringBuilder buf, int nibble) {
        if (nibble < 10) {
            buf.append((char)(48 + nibble));
        } else {
            buf.append((char)(65 + nibble - 10));
        }
    }

    static {
        String allowedPathChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~:/?#[]@!$&'()*+,;=";
        for (int i = 0; i < "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~:/?#[]@!$&'()*+,;=".length(); ++i) {
            ALLOWED_PATH_CHARS.set("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~:/?#[]@!$&'()*+,;=".charAt(i));
        }
        String allowedQueryChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~:/?#[]@!$&'()*,;=";
        for (int i = 0; i < "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~:/?#[]@!$&'()*,;=".length(); ++i) {
            ALLOWED_QUERY_CHARS.set("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~:/?#[]@!$&'()*,;=".charAt(i));
        }
        EMPTY_QUERY = new Bytes(0);
        ROOT_PATH = new Bytes(new byte[]{47});
        CACHE = Flags.parsedPathCacheSpec().map(PathAndQuery::buildCache).orElse(null);
    }

    private static final class CodePointIterator {
        private final CharSequence str;
        private final int end;
        private int pos;

        CodePointIterator(CharSequence str, int start, int end) {
            this.str = str;
            this.end = end;
            this.pos = start;
        }

        int position() {
            return this.pos;
        }

        void position(int pos) {
            this.pos = pos;
        }

        boolean hasNextCodePoint() {
            return this.pos < this.end;
        }

        int nextCodePoint() {
            char c2;
            char c1;
            assert (this.pos < this.end);
            if (Character.isHighSurrogate(c1 = this.str.charAt(this.pos++)) && this.pos < this.end && Character.isLowSurrogate(c2 = this.str.charAt(this.pos))) {
                ++this.pos;
                return Character.toCodePoint(c1, c2);
            }
            return c1;
        }
    }

    private static final class Bytes {
        byte[] data;
        int length;

        Bytes(int initialCapacity) {
            this.data = new byte[initialCapacity];
        }

        Bytes(byte[] data) {
            this.data = data;
            this.length = data.length;
        }

        void add(byte b) {
            this.data[this.length++] = b;
        }

        void ensure(int numBytes) {
            int newCapacity = this.length + numBytes;
            if (newCapacity <= this.data.length) {
                return;
            }
            newCapacity = (int)Math.max(Math.min((long)this.data.length + (long)(this.data.length >> 1), 0x7FFFFFF7L), (long)newCapacity);
            this.data = ByteArrays.forceCapacity(this.data, newCapacity, this.length);
        }
    }
}

