/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;

public final class PooledObjects {
    public static <T> T toUnpooled(T o) {
        if (o instanceof ByteBufHolder) {
            o = PooledObjects.copyAndRelease((ByteBufHolder)o);
        } else if (o instanceof ByteBuf) {
            o = PooledObjects.copyAndRelease((ByteBuf)o);
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T copyAndRelease(ByteBufHolder o) {
        try {
            ByteBufHolder copy;
            ByteBuf content = Unpooled.wrappedBuffer((byte[])ByteBufUtil.getBytes((ByteBuf)o.content()));
            ByteBufHolder byteBufHolder = copy = o.replace(content);
            return (T)byteBufHolder;
        }
        finally {
            ReferenceCountUtil.safeRelease((Object)o);
        }
    }

    private static <T> T copyAndRelease(ByteBuf o) {
        try {
            ByteBuf copy;
            ByteBuf byteBuf = copy = Unpooled.copiedBuffer((ByteBuf)o);
            return (T)byteBuf;
        }
        finally {
            ReferenceCountUtil.safeRelease((Object)o);
        }
    }

    private PooledObjects() {
    }
}

