/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class PublisherToHttpResponseConverter
implements Subscriber<Object> {
    private final ServiceRequestContext ctx;
    private final HttpRequest req;
    private final CompletableFuture<HttpResponse> future;
    private final ResponseConverterFunction responseConverter;
    private final ExceptionHandlerFunction exceptionHandler;
    @Nullable
    private Object firstElement;
    @Nullable
    private ImmutableList.Builder<Object> listBuilder;

    public PublisherToHttpResponseConverter(ServiceRequestContext ctx, HttpRequest req, CompletableFuture<HttpResponse> future, ResponseConverterFunction responseConverter, ExceptionHandlerFunction exceptionHandler) {
        this.ctx = Objects.requireNonNull(ctx, "ctx");
        this.req = Objects.requireNonNull(req, "req");
        this.future = Objects.requireNonNull(future, "future");
        this.responseConverter = Objects.requireNonNull(responseConverter, "responseConverter");
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler, "exceptionHandler");
    }

    public void onSubscribe(Subscription s) {
        s.request(Integer.MAX_VALUE);
    }

    public void onNext(Object o) {
        if (this.firstElement == null) {
            this.firstElement = o;
        } else {
            if (this.listBuilder == null) {
                this.listBuilder = ImmutableList.builder();
                this.listBuilder.add(this.firstElement);
            }
            this.listBuilder.add(o);
        }
    }

    public void onError(Throwable t) {
        this.future.complete(this.exceptionHandler.handleException(this.ctx, this.req, t));
    }

    public void onComplete() {
        ImmutableList<Object> obj;
        if (this.listBuilder != null) {
            obj = this.listBuilder.build();
            this.listBuilder = null;
        } else {
            obj = this.firstElement;
        }
        this.firstElement = null;
        try {
            this.future.complete(this.responseConverter.convertResponse(this.ctx, obj));
        }
        catch (Exception e) {
            this.onError(e);
        }
    }
}

