/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.internal.ChannelUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoop;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;

public enum TransportType {
    NIO(NioServerSocketChannel.class, NioSocketChannel.class, NioDatagramChannel.class, NioEventLoopGroup::new, NioEventLoopGroup.class, NioEventLoop.class),
    EPOLL(EpollServerSocketChannel.class, EpollSocketChannel.class, EpollDatagramChannel.class, EpollEventLoopGroup::new, EpollEventLoopGroup.class, ChannelUtil.epollEventLoopClass());

    private final Class<? extends ServerChannel> serverChannelClass;
    private final Class<? extends SocketChannel> socketChannelClass;
    private final Class<? extends DatagramChannel> datagramClass;
    private final Set<Class<? extends EventLoopGroup>> eventLoopGroupClasses;
    private final BiFunction<Integer, ThreadFactory, ? extends EventLoopGroup> eventLoopGroupConstructor;

    @SafeVarargs
    private TransportType(Class<? extends ServerChannel> serverChannelClass, Class<? extends SocketChannel> socketChannelClass, Class<? extends DatagramChannel> datagramClass, BiFunction<Integer, ThreadFactory, ? extends EventLoopGroup> eventLoopGroupConstructor, Class<? extends EventLoopGroup> ... eventLoopGroupClasses) {
        this.serverChannelClass = serverChannelClass;
        this.socketChannelClass = socketChannelClass;
        this.datagramClass = datagramClass;
        this.eventLoopGroupClasses = ImmutableSet.copyOf(eventLoopGroupClasses);
        this.eventLoopGroupConstructor = eventLoopGroupConstructor;
    }

    public Class<? extends ServerChannel> serverChannelClass() {
        return this.serverChannelClass;
    }

    public EventLoopGroup newEventLoopGroup(int nThreads, Function<TransportType, ThreadFactory> threadFactoryFactory) {
        ThreadFactory threadFactory = threadFactoryFactory.apply(this);
        return this.eventLoopGroupConstructor.apply(nThreads, threadFactory);
    }

    public static TransportType detectTransportType() {
        if (Flags.useEpoll()) {
            return EPOLL;
        }
        return NIO;
    }

    public static Class<? extends SocketChannel> socketChannelType(EventLoopGroup eventLoopGroup) {
        return TransportType.find((EventLoopGroup)eventLoopGroup).socketChannelClass;
    }

    public static Class<? extends DatagramChannel> datagramChannelType(EventLoopGroup eventLoopGroup) {
        return TransportType.find((EventLoopGroup)eventLoopGroup).datagramClass;
    }

    public static boolean isSupported(EventLoop eventLoop) {
        EventLoopGroup parent = eventLoop.parent();
        if (parent == null) {
            return false;
        }
        return TransportType.isSupported(parent);
    }

    public static boolean isSupported(EventLoopGroup eventLoopGroup) {
        return TransportType.findOrNull(eventLoopGroup) != null;
    }

    private static TransportType find(EventLoopGroup eventLoopGroup) {
        TransportType found = TransportType.findOrNull(eventLoopGroup);
        if (found == null) {
            throw TransportType.unsupportedEventLoopType(eventLoopGroup);
        }
        return found;
    }

    @Nullable
    private static TransportType findOrNull(EventLoopGroup eventLoopGroup) {
        for (TransportType type : TransportType.values()) {
            for (Class<? extends EventLoopGroup> eventLoopGroupClass : type.eventLoopGroupClasses) {
                if (!eventLoopGroupClass.isAssignableFrom(eventLoopGroup.getClass())) continue;
                return type;
            }
        }
        return null;
    }

    public String lowerCasedName() {
        return Ascii.toLowerCase(this.name());
    }

    private static IllegalStateException unsupportedEventLoopType(EventLoopGroup eventLoopGroup) {
        return new IllegalStateException("unsupported event loop type: " + eventLoopGroup.getClass().getName());
    }
}

