/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.crypto;

import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.ec.KeyFactorySpi;
import com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.security.AccessController;
import java.security.KeyFactorySpi;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import java.util.concurrent.Callable;

public final class BouncyCastleKeyFactoryProvider
extends Provider
implements ConfigurableProvider {
    private static final long serialVersionUID = -834653615603942658L;
    private static final String PROVIDER_NAME = "ABCKFC";

    public static void call(Runnable task) {
        try {
            BouncyCastleKeyFactoryProvider.call(() -> {
                task.run();
                return true;
            });
        }
        catch (Exception e) {
            Exceptions.throwUnsafely(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized <T> T call(Callable<T> task) throws Exception {
        boolean needToAdd = true;
        for (Provider provider : Security.getProviders()) {
            if (!(provider instanceof BouncyCastleKeyFactoryProvider)) continue;
            needToAdd = false;
            break;
        }
        if (needToAdd) {
            Security.addProvider(new BouncyCastleKeyFactoryProvider());
            try {
                T t = task.call();
                return t;
            }
            finally {
                Security.removeProvider(PROVIDER_NAME);
            }
        }
        return task.call();
    }

    private BouncyCastleKeyFactoryProvider() {
        super(PROVIDER_NAME, 1.0, "Armeria Bouncy Castle KeyFactory Collection");
        AccessController.doPrivileged(() -> {
            this.addKeyFactories();
            return true;
        });
    }

    private void addKeyFactories() {
        this.addKeyFactory(com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.rsa.KeyFactorySpi.class, "RSA");
        this.addKeyFactory(com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.dsa.KeyFactorySpi.class, "DSA");
        this.addKeyFactory(KeyFactorySpi.EC.class, "EC");
    }

    private void addKeyFactory(Class<? extends KeyFactorySpi> type, String name) {
        this.addAlgorithm("KeyFactory." + name, type.getName());
    }

    public void setParameter(String parameterName, Object parameter) {
    }

    public boolean hasAlgorithm(String type, String name) {
        return this.containsKey(type + '.' + name) || this.containsKey("Alg.Alias." + type + '.' + name);
    }

    public void addAlgorithm(String key, String value) {
        Preconditions.checkState(!this.containsKey(key), "duplicate algorithm: %s", key);
        this.put(key, value);
    }

    public void addAlgorithm(String type, ASN1ObjectIdentifier oid, String className) {
        this.addAlgorithm(type + '.' + oid, className);
        this.addAlgorithm(type + ".OID." + oid, className);
    }

    public void addKeyInfoConverter(ASN1ObjectIdentifier oid, AsymmetricKeyInfoConverter keyInfoConverter) {
    }

    public void addAttributes(String key, Map<String, String> attributeMap) {
        for (Map.Entry<String, String> e : attributeMap.entrySet()) {
            String attrKey = key + ' ' + e.getKey();
            Preconditions.checkState(!this.containsKey(attrKey), "duplicate attribute: %s", attrKey);
            this.put(attrKey, e.getValue());
        }
    }
}

