/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.logging;

import com.linecorp.armeria.internal.logging.Sampler;
import java.util.BitSet;
import java.util.Random;

final class CountingSampler
extends Sampler {
    private final BitSet sampleDecisions;
    private int counter;

    CountingSampler(float rate) {
        int outOf100 = (int)(rate * 100.0f);
        this.sampleDecisions = CountingSampler.randomBitSet(100, outOf100, new Random());
    }

    private static BitSet randomBitSet(int size, int cardinality, Random rnd) {
        int i;
        BitSet result = new BitSet(size);
        int[] chosen = new int[cardinality];
        for (i = 0; i < cardinality; ++i) {
            chosen[i] = i;
            result.set(i);
        }
        while (i < size) {
            int j = rnd.nextInt(i + 1);
            if (j < cardinality) {
                result.clear(chosen[j]);
                result.set(i);
                chosen[j] = i;
            }
            ++i;
        }
        return result;
    }

    @Override
    public synchronized boolean isSampled() {
        boolean result = this.sampleDecisions.get(this.counter++);
        if (this.counter == 100) {
            this.counter = 0;
        }
        return result;
    }
}

