/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.logging;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.logging.LogLevel;
import com.linecorp.armeria.common.logging.RequestLog;
import java.util.function.Function;
import org.slf4j.Logger;

public final class LoggingDecorators {
    private static final String REQUEST_FORMAT = "Request: {}";
    private static final String RESPONSE_FORMAT = "Response: {}";

    private LoggingDecorators() {
    }

    public static void logRequest(Logger logger, RequestLog log, LogLevel requestLogLevel, Function<HttpHeaders, HttpHeaders> requestHeadersSanitizer, Function<Object, Object> requestContentSanitizer) {
        if (requestLogLevel.isEnabled(logger)) {
            requestLogLevel.log(logger, REQUEST_FORMAT, log.toStringRequestOnly(requestHeadersSanitizer, requestContentSanitizer));
        }
    }

    public static void logResponse(Logger logger, RequestLog log, LogLevel requestLogLevel, Function<HttpHeaders, HttpHeaders> requestHeadersSanitizer, Function<Object, Object> requestContentSanitizer, LogLevel successfulResponseLogLevel, LogLevel failedResponseLogLevel, Function<HttpHeaders, HttpHeaders> responseHeadersSanitizer, Function<Object, Object> responseContentSanitizer) {
        LogLevel level;
        LogLevel logLevel = level = log.responseCause() == null ? successfulResponseLogLevel : failedResponseLogLevel;
        if (level.isEnabled(logger)) {
            if (log.responseCause() == null) {
                level.log(logger, RESPONSE_FORMAT, log.toStringResponseOnly(responseHeadersSanitizer, responseContentSanitizer));
            } else {
                if (!requestLogLevel.isEnabled(logger)) {
                    level.log(logger, REQUEST_FORMAT, log.toStringRequestOnly(requestHeadersSanitizer, responseContentSanitizer));
                }
                level.log(logger, RESPONSE_FORMAT, log.toStringResponseOnly(responseHeadersSanitizer, responseContentSanitizer), log.responseCause());
            }
        }
    }
}

