/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.logging;

import com.linecorp.armeria.internal.logging.CountingSampler;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;

public abstract class Sampler {
    static final Sampler ALWAYS_SAMPLE = new Sampler(){

        @Override
        public boolean isSampled() {
            return true;
        }

        public String toString() {
            return "AlwaysSample";
        }
    };
    static final Sampler NEVER_SAMPLE = new Sampler(){

        @Override
        public boolean isSampled() {
            return false;
        }

        public String toString() {
            return "NeverSample";
        }
    };

    public abstract boolean isSampled();

    public static Sampler create(float rate) {
        if ((double)rate >= 1.0) {
            return ALWAYS_SAMPLE;
        }
        if ((double)rate == 0.0) {
            return NEVER_SAMPLE;
        }
        Preconditions.checkArgument(rate >= 0.01f && rate < 1.0f, "rate should be between 0.01 and 1: was %s", (Object)Float.valueOf(rate));
        return new CountingSampler(rate);
    }

    public static Sampler always() {
        return ALWAYS_SAMPLE;
    }
}

